/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.mem.MemBuffer;

public class DataTypeInstance {
    private DataType dataType;
    private int length;

    protected DataTypeInstance(DataType dt, int length) {
        this.dataType = dt;
        this.length = length;
        if (length < 1) {
            length = dt.getLength() > 0 ? dt.getLength() : 1;
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String toString() {
        return this.dataType.toString();
    }

    public static DataTypeInstance getDataTypeInstance(DataType dataType, MemBuffer buf, boolean useAlignedLength) {
        return DataTypeInstance.getDataTypeInstance(dataType, buf, -1, useAlignedLength);
    }

    public static DataTypeInstance getDataTypeInstance(DataType dataType, int length, boolean useAlignedLength) {
        if (dataType == null) {
            return null;
        }
        if (dataType instanceof FactoryDataType) {
            return null;
        }
        boolean isFunctionDef = dataType instanceof FunctionDefinition;
        if (dataType instanceof TypeDef) {
            isFunctionDef = ((TypeDef)dataType).getBaseDataType() instanceof FunctionDefinition;
        }
        if (isFunctionDef) {
            dataType = new PointerDataType(dataType, -1, dataType.getDataTypeManager());
            length = dataType.getLength();
        } else if (dataType instanceof Dynamic) {
            Dynamic dynamicDataType = (Dynamic)dataType;
            if (length <= 0 || !dynamicDataType.canSpecifyLength()) {
                return null;
            }
        } else {
            length = useAlignedLength ? dataType.getAlignedLength() : dataType.getLength();
        }
        if (length < 0) {
            return null;
        }
        return new DataTypeInstance(dataType, length);
    }

    public static DataTypeInstance getDataTypeInstance(DataType dataType, MemBuffer buf, int length, boolean useAlignedLength) {
        if (dataType instanceof FactoryDataType) {
            dataType = ((FactoryDataType)dataType).getDataType(buf);
            length = -1;
        }
        if (dataType == null) {
            return null;
        }
        boolean isFunctionDef = dataType instanceof FunctionDefinition;
        if (dataType instanceof TypeDef) {
            isFunctionDef = ((TypeDef)dataType).getBaseDataType() instanceof FunctionDefinition;
        }
        if (isFunctionDef) {
            dataType = new PointerDataType(dataType, -1, dataType.getDataTypeManager());
            length = dataType.getLength();
        } else if (dataType instanceof Dynamic) {
            Dynamic dynamicDataType = (Dynamic)dataType;
            length = dynamicDataType.getLength(buf, length);
        } else {
            length = useAlignedLength ? dataType.getAlignedLength() : dataType.getLength();
        }
        if (length < 0) {
            return null;
        }
        return new DataTypeInstance(dataType, length);
    }
}

