/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.SwatchPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.UIManager;

class HistorySwatchPanel
extends SwatchPanel {
    private List<Color> historyColors;

    HistorySwatchPanel(List<Color> recentColors) {
        this.setHistoryColors(recentColors);
    }

    void setHistoryColors(List<Color> recentColors) {
        this.historyColors = recentColors;
        this.initColors();
    }

    @Override
    protected void initValues() {
        this.swatchSize = UIManager.getDimension("ColorChooser.swatchesRecentSwatchSize");
        this.numSwatches = new Dimension(5, 7);
        this.gap = new Dimension(1, 1);
    }

    @Override
    protected void initColors() {
        Color defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
        int numColors = this.numSwatches.width * this.numSwatches.height;
        this.colors = new Color[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.colors[i] = defaultRecentColor;
        }
        if (this.historyColors != null && this.historyColors.size() > 0) {
            int recentColorCount = this.historyColors.size();
            for (int i = 0; i < recentColorCount; ++i) {
                this.colors[i] = this.historyColors.get(i);
            }
        }
    }
}

