/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.specification;

import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CommonAbstractCriteria;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Root;
import org.hibernate.Incubating;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.restriction.Restriction;
import org.hibernate.query.specification.QuerySpecification;
import org.hibernate.query.specification.internal.MutationSpecificationImpl;

@Incubating
public interface MutationSpecification<T>
extends QuerySpecification<T> {
    @Override
    public MutationSpecification<T> restrict(Restriction<? super T> var1);

    public MutationSpecification<T> augment(Augmentation<T> var1);

    @Override
    public MutationQuery createQuery(Session var1);

    @Override
    public MutationQuery createQuery(StatelessSession var1);

    @Override
    public MutationSpecification<T> validate(CriteriaBuilder var1);

    @Override
    public TypedQueryReference<Void> reference();

    public static <T> MutationSpecification<T> create(Class<T> mutationTarget, String hql) {
        return new MutationSpecificationImpl<T>(hql, mutationTarget);
    }

    public static <T> MutationSpecification<T> create(CriteriaUpdate<T> criteriaUpdate) {
        return new MutationSpecificationImpl<T>(criteriaUpdate);
    }

    public static <T> MutationSpecification<T> create(CriteriaDelete<T> criteriaDelete) {
        return new MutationSpecificationImpl<T>(criteriaDelete);
    }

    @FunctionalInterface
    public static interface Augmentation<T> {
        public void augment(CriteriaBuilder var1, CommonAbstractCriteria var2, Root<T> var3);
    }
}

