/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2024-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#pragma once

// 3rd party
#include "nlohmann/json.hpp"
// sharp_am
#include "metrics.h"

/**
 * telemetry metrics configuration
 */
struct TelemetryConfig
{
    Metrics::Config metrics_config;
};

void to_json(nlohmann::ordered_json& j, const TelemetryConfig& config);
void from_json(const nlohmann::ordered_json& j, TelemetryConfig& config);
