/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyQuickFixUtil;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.pyi.PyiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PyMissingTypeHintsInspection
extends PyInspection {
    public boolean m_onlyWhenTypesAreKnown = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMissingTypeHintsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyMissingTypeHintsInspection.$$$reportNull$$$0(1);
        }
        return new PyInspectionVisitor(holder, PyInspectionVisitor.getContext(session)){

            public void visitPyFunction(@NotNull PyFunction function) {
                ASTNode nameNode;
                boolean flag;
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (function.getTypeComment() == null && !PyMissingTypeHintsInspection.typeAnnotationsExist(function) && PyiUtil.getOverloads(function, this.getResolveContext().getTypeEvalContext()).isEmpty() && (flag = PyMissingTypeHintsInspection.this.shouldRegisterProblem(function)) && (nameNode = function.getNameNode()) != null) {
                    this.registerProblem(nameNode.getPsi(), PyPsiBundle.message("INSP.missing.type.hints.type.hinting.missing.for.function.definition", new Object[0]), new AddTypeHintsQuickFix(function.getName()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/inspections/PyMissingTypeHintsInspection$1", "visitPyFunction"));
            }
        };
    }

    private boolean shouldRegisterProblem(PyFunction function) {
        if (this.m_onlyWhenTypesAreKnown) {
            PySignatureCacheManager instance = PySignatureCacheManager.getInstance((Project)function.getProject());
            if (instance != null) {
                PySignature signature = instance.findSignature((PyAstFunction)function);
                return signature != null && PyMissingTypeHintsInspection.canAnnotate(signature);
            }
            return false;
        }
        return true;
    }

    private static boolean canAnnotate(@NotNull PySignature signature) {
        if (signature == null) {
            PyMissingTypeHintsInspection.$$$reportNull$$$0(2);
        }
        return !"NoneType".equals(signature.getReturnTypeQualifiedName()) || signature.getArgs().size() > 1 || signature.getArgs().size() == 1 && !"self".equals(((PySignature.NamedParameter)signature.getArgs().get(0)).getName());
    }

    private static boolean typeAnnotationsExist(PyFunction function) {
        for (PyParameter param : function.getParameterList().getParameters()) {
            PyNamedParameter namedParameter = param.getAsNamed();
            if (namedParameter == null || namedParameter.getAnnotation() == null) continue;
            return true;
        }
        return function.getAnnotation() != null;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_onlyWhenTypesAreKnown", (String)PyPsiBundle.message("INSP.missing.type.hints.checkbox.only.when.types.are.known", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PyMissingTypeHintsInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMissingTypeHintsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMissingTypeHintsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canAnnotate";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class AddTypeHintsQuickFix
    implements LocalQuickFix {
        private final String myName;

        AddTypeHintsQuickFix(@NotNull String name) {
            if (name == null) {
                AddTypeHintsQuickFix.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = PyPsiBundle.message("INSP.missing.type.hints.add.type.hints.for", this.myName);
            if (string == null) {
                AddTypeHintsQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.missing.type.hints.add.type.hints", new Object[0]);
            if (string == null) {
                AddTypeHintsQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PyFunction function;
            if (project == null) {
                AddTypeHintsQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddTypeHintsQuickFix.$$$reportNull$$$0(4);
            }
            if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PyFunction.class)) != null) {
                PythonUiService.getInstance().annotateTypesIntention(PyQuickFixUtil.getEditor((PsiElement)function), function);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyMissingTypeHintsInspection$AddTypeHintsQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyMissingTypeHintsInspection$AddTypeHintsQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

