; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+sse | FileCheck %s --check-prefix=SSE
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512dq,+avx512vl | FileCheck %s --check-prefix=AVX

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/sse-builtins.c

define <4 x float> @test_mm_cvtsi64_ss(<4 x float> %a0, i64 %a1) nounwind {
; SSE-LABEL: test_mm_cvtsi64_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtsi2ss %rdi, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_mm_cvtsi64_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtsi2ss %rdi, %xmm0, %xmm0
; AVX-NEXT:    retq
  %res = call <4 x float> @llvm.x86.sse.cvtsi642ss(<4 x float> %a0, i64 %a1)
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.cvtsi642ss(<4 x float>, i64) nounwind readnone

define i64 @test_mm_cvtss_si64(<4 x float> %a0) nounwind {
; SSE-LABEL: test_mm_cvtss_si64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtss2si %xmm0, %rax
; SSE-NEXT:    retq
;
; AVX-LABEL: test_mm_cvtss_si64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtss2si %xmm0, %rax
; AVX-NEXT:    retq
  %res = call i64 @llvm.x86.sse.cvtss2si64(<4 x float> %a0)
  ret i64 %res
}
declare i64 @llvm.x86.sse.cvtss2si64(<4 x float>) nounwind readnone

define i64 @test_mm_cvttss_si64(<4 x float> %a0) nounwind {
; SSE-LABEL: test_mm_cvttss_si64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvttss2si %xmm0, %rax
; SSE-NEXT:    retq
;
; AVX-LABEL: test_mm_cvttss_si64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvttss2si %xmm0, %rax
; AVX-NEXT:    retq
  %res = call i64 @llvm.x86.sse.cvttss2si64(<4 x float> %a0)
  ret i64 %res
}
declare i64 @llvm.x86.sse.cvttss2si64(<4 x float>) nounwind readnone
