; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1150 -amdgpu-sdwa-peephole=0 -verify-machineinstrs < %s | FileCheck -check-prefix=SDAG %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1150 -amdgpu-sdwa-peephole=0 -verify-machineinstrs < %s | FileCheck -check-prefix=GISEL %s

define amdgpu_vs void @fcmp_f32_olt_to_ogt(ptr addrspace(1) inreg %out, float inreg %a) {
; SDAG-LABEL: fcmp_f32_olt_to_ogt:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_gt_f32 s2, 2.0
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f32_olt_to_ogt:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_gt_f32 s2, 2.0
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp olt float 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f32_ogt_to_olt(ptr addrspace(1) inreg %out, float inreg %a) {
; SDAG-LABEL: fcmp_f32_ogt_to_olt:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_lt_f32 s2, 2.0
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f32_ogt_to_olt:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_lt_f32 s2, 2.0
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ogt float 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f32_ole_to_oge(ptr addrspace(1) inreg %out, float inreg %a) {
; SDAG-LABEL: fcmp_f32_ole_to_oge:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_ge_f32 s2, 2.0
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f32_ole_to_oge:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_ge_f32 s2, 2.0
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ole float 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f32_oge_to_ole(ptr addrspace(1) inreg %out, float inreg %a) {
; SDAG-LABEL: fcmp_f32_oge_to_ole:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_le_f32 s2, 2.0
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f32_oge_to_ole:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_le_f32 s2, 2.0
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp oge float 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f32_ult_to_ugt(ptr addrspace(1) inreg %out, float inreg %a) {
; SDAG-LABEL: fcmp_f32_ult_to_ugt:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_nle_f32 s2, 2.0
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f32_ult_to_ugt:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_nle_f32 s2, 2.0
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ult float 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f32_ugt_to_ult(ptr addrspace(1) inreg %out, float inreg %a) {
; SDAG-LABEL: fcmp_f32_ugt_to_ult:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_nge_f32 s2, 2.0
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f32_ugt_to_ult:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_nge_f32 s2, 2.0
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ugt float 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f32_ule_to_uge(ptr addrspace(1) inreg %out, float inreg %a) {
; SDAG-LABEL: fcmp_f32_ule_to_uge:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_nlt_f32 s2, 2.0
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f32_ule_to_uge:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_nlt_f32 s2, 2.0
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ule float 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f32_uge_to_ule(ptr addrspace(1) inreg %out, float inreg %a) {
; SDAG-LABEL: fcmp_f32_uge_to_ule:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_ngt_f32 s2, 2.0
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f32_uge_to_ule:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_ngt_f32 s2, 2.0
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp uge float 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f16_olt_to_ogt(ptr addrspace(1) inreg %out, half inreg %a) {
; SDAG-LABEL: fcmp_f16_olt_to_ogt:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_gt_f16 s2, 0x4000
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f16_olt_to_ogt:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_gt_f16 s2, 0x4000
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp olt half 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f16_ogt_to_olt(ptr addrspace(1) inreg %out, half inreg %a) {
; SDAG-LABEL: fcmp_f16_ogt_to_olt:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_lt_f16 s2, 0x4000
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f16_ogt_to_olt:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_lt_f16 s2, 0x4000
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ogt half 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f16_ole_to_oge(ptr addrspace(1) inreg %out, half inreg %a) {
; SDAG-LABEL: fcmp_f16_ole_to_oge:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_ge_f16 s2, 0x4000
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f16_ole_to_oge:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_ge_f16 s2, 0x4000
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ole half 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f16_oge_to_ole(ptr addrspace(1) inreg %out, half inreg %a) {
; SDAG-LABEL: fcmp_f16_oge_to_ole:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_le_f16 s2, 0x4000
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f16_oge_to_ole:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_le_f16 s2, 0x4000
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp oge half 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f16_ult_to_ugt(ptr addrspace(1) inreg %out, half inreg %a) {
; SDAG-LABEL: fcmp_f16_ult_to_ugt:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_nle_f16 s2, 0x4000
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f16_ult_to_ugt:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_nle_f16 s2, 0x4000
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ult half 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_f16_ugt_to_ult(ptr addrspace(1) inreg %out, half inreg %a) {
; SDAG-LABEL: fcmp_f16_ugt_to_ult:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_nge_f16 s2, 0x4000
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_f16_ugt_to_ult:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_nge_f16 s2, 0x4000
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ugt half 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_ule_to_uge(ptr addrspace(1) inreg %out, half inreg %a) {
; SDAG-LABEL: fcmp_ule_to_uge:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_nlt_f16 s2, 0x4000
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_ule_to_uge:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_nlt_f16 s2, 0x4000
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp ule half 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}

define amdgpu_vs void @fcmp_uge_to_ule(ptr addrspace(1) inreg %out, half inreg %a) {
; SDAG-LABEL: fcmp_uge_to_ule:
; SDAG:       ; %bb.0: ; %entry
; SDAG-NEXT:    s_cmp_ngt_f16 s2, 0x4000
; SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-NEXT:    s_cselect_b32 s2, -1, 0
; SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; SDAG-NEXT:    v_cndmask_b32_e64 v1, 0, -1, s2
; SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; SDAG-NEXT:    s_endpgm
;
; GISEL-LABEL: fcmp_uge_to_ule:
; GISEL:       ; %bb.0: ; %entry
; GISEL-NEXT:    s_cmp_ngt_f16 s2, 0x4000
; GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-NEXT:    s_cselect_b32 s2, 1, 0
; GISEL-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GISEL-NEXT:    s_bfe_i32 s2, s2, 0x10000
; GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GISEL-NEXT:    s_endpgm
entry:
  %0 = fcmp uge half 2.0, %a
  %1 = sext i1 %0 to i32
  store i32 %1, ptr addrspace(1) %out
  ret void
}
