; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop | FileCheck %s --check-prefixes=XOP
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx | FileCheck %s --check-prefixes=XOP
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL,AVX512VL-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512VL,AVX512VLBW

; These test cases are inspired by C++2a std::midpoint().
; See https://bugs.llvm.org/show_bug.cgi?id=40965

; Using 256-bit vector regs.

; ---------------------------------------------------------------------------- ;
; 32-bit width. 256 / 32 = 8 elts.
; ---------------------------------------------------------------------------- ;

; Values come from regs

define <8 x i32> @vec256_i32_signed_reg_reg(<8 x i32> %a1, <8 x i32> %a2) nounwind {
; AVX1-LABEL: vec256_i32_signed_reg_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpminsd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpsubd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpminsd %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpmaxsd %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $1, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $1, %xmm2, %xmm2
; AVX1-NEXT:    vpmulld %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpmulld %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_signed_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i32_signed_reg_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpminsd %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpmaxsd %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpsubd %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpminsd %xmm1, %xmm0, %xmm4
; XOP-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOP-NEXT:    vpsrld $1, %xmm2, %xmm2
; XOP-NEXT:    vpmacsdd %xmm3, %xmm2, %xmm2, %xmm2
; XOP-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_signed_reg_reg:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX512-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX512-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %t3 = icmp sgt <8 x i32> %a1, %a2 ; signed
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul nsw <8 x i32> %t8, %t8 ; signed
  %a10 = add nsw <8 x i32> %t9, %a1 ; signed
  ret <8 x i32> %a10
}

define <8 x i32> @vec256_i32_unsigned_reg_reg(<8 x i32> %a1, <8 x i32> %a2) nounwind {
; AVX1-LABEL: vec256_i32_unsigned_reg_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpminud %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpsubd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpminud %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpmaxud %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $1, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $1, %xmm2, %xmm2
; AVX1-NEXT:    vpmulld %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpmulld %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_unsigned_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminud %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxud %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i32_unsigned_reg_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpminud %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpmaxud %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpsubd %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpminud %xmm1, %xmm0, %xmm4
; XOP-NEXT:    vpmaxud %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOP-NEXT:    vpsrld $1, %xmm2, %xmm2
; XOP-NEXT:    vpmacsdd %xmm3, %xmm2, %xmm2, %xmm2
; XOP-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_unsigned_reg_reg:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminud %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxud %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX512-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX512-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %t3 = icmp ugt <8 x i32> %a1, %a2
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul <8 x i32> %t8, %t8
  %a10 = add <8 x i32> %t9, %a1
  ret <8 x i32> %a10
}

; Values are loaded. Only check signed case.

define <8 x i32> @vec256_i32_signed_mem_reg(ptr %a1_addr, <8 x i32> %a2) nounwind {
; AVX1-LABEL: vec256_i32_signed_mem_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vpminsd %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vpmaxsd %xmm0, %xmm1, %xmm4
; AVX1-NEXT:    vpsubd %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpminsd %xmm0, %xmm2, %xmm4
; AVX1-NEXT:    vpmaxsd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsubd %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsrld $1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrld $1, %xmm3, %xmm3
; AVX1-NEXT:    vpmulld %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpmulld %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_signed_mem_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpminsd %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $1, %ymm0, %ymm0
; AVX2-NEXT:    vpmulld %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i32_signed_mem_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOP-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-NEXT:    vpminsd %xmm1, %xmm3, %xmm4
; XOP-NEXT:    vpmaxsd %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpminsd %xmm0, %xmm2, %xmm4
; XOP-NEXT:    vpmaxsd %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vpsubd %xmm4, %xmm0, %xmm0
; XOP-NEXT:    vpsrld $1, %xmm0, %xmm0
; XOP-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOP-NEXT:    vpmacsdd %xmm3, %xmm1, %xmm1, %xmm1
; XOP-NEXT:    vpmacsdd %xmm2, %xmm0, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_signed_mem_reg:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512-NEXT:    vpminsd %ymm0, %ymm1, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vpsubd %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpsrld $1, %ymm0, %ymm0
; AVX512-NEXT:    vpmulld %ymm0, %ymm0, %ymm0
; AVX512-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %a1 = load <8 x i32>, ptr %a1_addr
  %t3 = icmp sgt <8 x i32> %a1, %a2 ; signed
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul nsw <8 x i32> %t8, %t8 ; signed
  %a10 = add nsw <8 x i32> %t9, %a1 ; signed
  ret <8 x i32> %a10
}

define <8 x i32> @vec256_i32_signed_reg_mem(<8 x i32> %a1, ptr %a2_addr) nounwind {
; AVX1-LABEL: vec256_i32_signed_reg_mem:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %ymm1
; AVX1-NEXT:    vpminsd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vpsubd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpminsd %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpmaxsd %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $1, %xmm1, %xmm1
; AVX1-NEXT:    vpsrld $1, %xmm2, %xmm2
; AVX1-NEXT:    vpmulld %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpmulld %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_signed_reg_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i32_signed_reg_mem:
; XOP:       # %bb.0:
; XOP-NEXT:    vmovdqa (%rdi), %ymm1
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm3
; XOP-NEXT:    vpminsd %xmm3, %xmm2, %xmm4
; XOP-NEXT:    vpmaxsd %xmm3, %xmm2, %xmm3
; XOP-NEXT:    vpsubd %xmm4, %xmm3, %xmm3
; XOP-NEXT:    vpminsd %xmm1, %xmm0, %xmm4
; XOP-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOP-NEXT:    vpsrld $1, %xmm3, %xmm3
; XOP-NEXT:    vpmacsdd %xmm2, %xmm3, %xmm3, %xmm2
; XOP-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_signed_reg_mem:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX512-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX512-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %a2 = load <8 x i32>, ptr %a2_addr
  %t3 = icmp sgt <8 x i32> %a1, %a2 ; signed
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul nsw <8 x i32> %t8, %t8 ; signed
  %a10 = add nsw <8 x i32> %t9, %a1 ; signed
  ret <8 x i32> %a10
}

define <8 x i32> @vec256_i32_signed_mem_mem(ptr %a1_addr, ptr %a2_addr) nounwind {
; AVX1-LABEL: vec256_i32_signed_mem_mem:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rsi), %ymm0
; AVX1-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vpminsd %xmm0, %xmm1, %xmm3
; AVX1-NEXT:    vpmaxsd %xmm0, %xmm1, %xmm4
; AVX1-NEXT:    vpsubd %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpminsd %xmm0, %xmm2, %xmm4
; AVX1-NEXT:    vpmaxsd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsubd %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsrld $1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrld $1, %xmm3, %xmm3
; AVX1-NEXT:    vpmulld %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpmulld %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_signed_mem_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i32_signed_mem_mem:
; XOP:       # %bb.0:
; XOP-NEXT:    vmovdqa (%rsi), %ymm0
; XOP-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpminsd %xmm3, %xmm2, %xmm4
; XOP-NEXT:    vpmaxsd %xmm3, %xmm2, %xmm3
; XOP-NEXT:    vpsubd %xmm4, %xmm3, %xmm3
; XOP-NEXT:    vpminsd %xmm0, %xmm1, %xmm4
; XOP-NEXT:    vpmaxsd %xmm0, %xmm1, %xmm0
; XOP-NEXT:    vpsubd %xmm4, %xmm0, %xmm0
; XOP-NEXT:    vpsrld $1, %xmm0, %xmm0
; XOP-NEXT:    vpsrld $1, %xmm3, %xmm3
; XOP-NEXT:    vpmacsdd %xmm2, %xmm3, %xmm3, %xmm2
; XOP-NEXT:    vpmacsdd %xmm1, %xmm0, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_signed_mem_mem:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX512-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX512-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %a1 = load <8 x i32>, ptr %a1_addr
  %a2 = load <8 x i32>, ptr %a2_addr
  %t3 = icmp sgt <8 x i32> %a1, %a2 ; signed
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul nsw <8 x i32> %t8, %t8 ; signed
  %a10 = add nsw <8 x i32> %t9, %a1 ; signed
  ret <8 x i32> %a10
}

; ---------------------------------------------------------------------------- ;
; 64-bit width. 256 / 64 = 4 elts.
; ---------------------------------------------------------------------------- ;

; Values come from regs

define <4 x i64> @vec256_i64_signed_reg_reg(<4 x i64> %a1, <4 x i64> %a2) nounwind {
; AVX1-LABEL: vec256_i64_signed_reg_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm6
; AVX1-NEXT:    vpsrlq $1, %xmm1, %xmm7
; AVX1-NEXT:    vpsrlq $33, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; AVX1-NEXT:    vpor %xmm5, %xmm8, %xmm9
; AVX1-NEXT:    vpmuludq %xmm1, %xmm9, %xmm1
; AVX1-NEXT:    vpsrlq $32, %xmm5, %xmm5
; AVX1-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpaddq %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; AVX1-NEXT:    vpsrlq $33, %xmm2, %xmm2
; AVX1-NEXT:    vpor %xmm4, %xmm8, %xmm7
; AVX1-NEXT:    vpmuludq %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq $32, %xmm4, %xmm4
; AVX1-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpaddq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllq $32, %xmm2, %xmm2
; AVX1-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; AVX1-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_signed_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm4
; AVX2-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i64_signed_reg_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtq %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpsubq %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; XOP-NEXT:    vpsubq %xmm1, %xmm5, %xmm1
; XOP-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpxor %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpsubq %xmm2, %xmm4, %xmm2
; XOP-NEXT:    vpsrlq $1, %xmm2, %xmm6
; XOP-NEXT:    vpsrlq $1, %xmm1, %xmm7
; XOP-NEXT:    vpsrlq $33, %xmm1, %xmm1
; XOP-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; XOP-NEXT:    vpor %xmm5, %xmm8, %xmm9
; XOP-NEXT:    vpmuludq %xmm1, %xmm9, %xmm1
; XOP-NEXT:    vpsrlq $32, %xmm5, %xmm5
; XOP-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; XOP-NEXT:    vpaddq %xmm1, %xmm5, %xmm1
; XOP-NEXT:    vpsllq $32, %xmm1, %xmm1
; XOP-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; XOP-NEXT:    vpsrlq $33, %xmm2, %xmm2
; XOP-NEXT:    vpor %xmm4, %xmm8, %xmm7
; XOP-NEXT:    vpmuludq %xmm7, %xmm2, %xmm2
; XOP-NEXT:    vpsrlq $32, %xmm4, %xmm4
; XOP-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm2, %xmm4, %xmm2
; XOP-NEXT:    vpsllq $32, %xmm2, %xmm2
; XOP-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; XOP-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; XOP-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_signed_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512F-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $1, %ymm1, %ymm2
; AVX512F-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512F-NEXT:    vpaddq %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_signed_reg_reg:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpgtq %ymm1, %ymm0, %k1
; AVX512VL-NEXT:    vpminsq %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpsubq %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_signed_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm4, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %t3 = icmp sgt <4 x i64> %a1, %a2 ; signed
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul nsw <4 x i64> %t8, %t4 ; signed
  %a10 = add nsw <4 x i64> %t9, %a1 ; signed
  ret <4 x i64> %a10
}

define <4 x i64> @vec256_i64_unsigned_reg_reg(<4 x i64> %a1, <4 x i64> %a2) nounwind {
; AVX1-LABEL: vec256_i64_unsigned_reg_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vmovddup {{.*#+}} xmm4 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    # xmm4 = mem[0,0]
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm6
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm6
; AVX1-NEXT:    vpxor %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpsubq %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpsubq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpsrlq $1, %xmm3, %xmm6
; AVX1-NEXT:    vpsrlq $1, %xmm1, %xmm7
; AVX1-NEXT:    vpsrlq $33, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; AVX1-NEXT:    vpor %xmm4, %xmm8, %xmm9
; AVX1-NEXT:    vpmuludq %xmm1, %xmm9, %xmm1
; AVX1-NEXT:    vpsrlq $32, %xmm4, %xmm4
; AVX1-NEXT:    vpmuludq %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpaddq %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vpmuludq %xmm7, %xmm9, %xmm4
; AVX1-NEXT:    vpsrlq $33, %xmm3, %xmm3
; AVX1-NEXT:    vpor %xmm5, %xmm8, %xmm7
; AVX1-NEXT:    vpmuludq %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlq $32, %xmm5, %xmm5
; AVX1-NEXT:    vpmuludq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpsllq $32, %xmm3, %xmm3
; AVX1-NEXT:    vpmuludq %xmm7, %xmm6, %xmm5
; AVX1-NEXT:    vpaddq %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_unsigned_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm4
; AVX2-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i64_unsigned_reg_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtuq %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtuq %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpsubq %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; XOP-NEXT:    vpsubq %xmm1, %xmm5, %xmm1
; XOP-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpxor %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpsubq %xmm2, %xmm4, %xmm2
; XOP-NEXT:    vpsrlq $1, %xmm2, %xmm6
; XOP-NEXT:    vpsrlq $1, %xmm1, %xmm7
; XOP-NEXT:    vpsrlq $33, %xmm1, %xmm1
; XOP-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; XOP-NEXT:    vpor %xmm5, %xmm8, %xmm9
; XOP-NEXT:    vpmuludq %xmm1, %xmm9, %xmm1
; XOP-NEXT:    vpsrlq $32, %xmm5, %xmm5
; XOP-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; XOP-NEXT:    vpaddq %xmm1, %xmm5, %xmm1
; XOP-NEXT:    vpsllq $32, %xmm1, %xmm1
; XOP-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; XOP-NEXT:    vpsrlq $33, %xmm2, %xmm2
; XOP-NEXT:    vpor %xmm4, %xmm8, %xmm7
; XOP-NEXT:    vpmuludq %xmm7, %xmm2, %xmm2
; XOP-NEXT:    vpsrlq $32, %xmm4, %xmm4
; XOP-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm2, %xmm4, %xmm2
; XOP-NEXT:    vpsllq $32, %xmm2, %xmm2
; XOP-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; XOP-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; XOP-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_unsigned_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpcmpnleuq %zmm1, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminuq %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm1
; AVX512F-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $1, %ymm1, %ymm2
; AVX512F-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512F-NEXT:    vpaddq %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_unsigned_reg_reg:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpnleuq %ymm1, %ymm0, %k1
; AVX512VL-NEXT:    vpminuq %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpmaxuq %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpsubq %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_unsigned_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpnleuq %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminuq %zmm1, %zmm0, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm4, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %t3 = icmp ugt <4 x i64> %a1, %a2
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul <4 x i64> %t8, %t4
  %a10 = add <4 x i64> %t9, %a1
  ret <4 x i64> %a10
}

; Values are loaded. Only check signed case.

define <4 x i64> @vec256_i64_signed_mem_reg(ptr %a1_addr, <4 x i64> %a2) nounwind {
; AVX1-LABEL: vec256_i64_signed_mem_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpsubq %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpxor %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpsubq %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpsrlq $1, %xmm1, %xmm6
; AVX1-NEXT:    vpsrlq $1, %xmm0, %xmm7
; AVX1-NEXT:    vpsrlq $33, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; AVX1-NEXT:    vpor %xmm5, %xmm8, %xmm9
; AVX1-NEXT:    vpmuludq %xmm0, %xmm9, %xmm0
; AVX1-NEXT:    vpsrlq $32, %xmm5, %xmm5
; AVX1-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX1-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; AVX1-NEXT:    vpsrlq $33, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm4, %xmm8, %xmm7
; AVX1-NEXT:    vpmuludq %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlq $32, %xmm4, %xmm4
; AVX1-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpaddq %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; AVX1-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpaddq %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpaddq %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_signed_mem_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpsrlq $1, %ymm0, %ymm4
; AVX2-NEXT:    vpsrlq $33, %ymm0, %ymm0
; AVX2-NEXT:    vpmuludq %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i64_signed_mem_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOP-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-NEXT:    vpcomgtq %xmm1, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtq %xmm0, %xmm2, %xmm5
; XOP-NEXT:    vpsubq %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vpxor %xmm5, %xmm0, %xmm0
; XOP-NEXT:    vpsubq %xmm0, %xmm5, %xmm0
; XOP-NEXT:    vpsubq %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpxor %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpsubq %xmm1, %xmm4, %xmm1
; XOP-NEXT:    vpsrlq $1, %xmm1, %xmm6
; XOP-NEXT:    vpsrlq $1, %xmm0, %xmm7
; XOP-NEXT:    vpsrlq $33, %xmm0, %xmm0
; XOP-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; XOP-NEXT:    vpor %xmm5, %xmm8, %xmm9
; XOP-NEXT:    vpmuludq %xmm0, %xmm9, %xmm0
; XOP-NEXT:    vpsrlq $32, %xmm5, %xmm5
; XOP-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; XOP-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; XOP-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; XOP-NEXT:    vpsrlq $33, %xmm1, %xmm1
; XOP-NEXT:    vpor %xmm4, %xmm8, %xmm7
; XOP-NEXT:    vpmuludq %xmm7, %xmm1, %xmm1
; XOP-NEXT:    vpsrlq $32, %xmm4, %xmm4
; XOP-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm1, %xmm4, %xmm1
; XOP-NEXT:    vpsllq $32, %xmm1, %xmm1
; XOP-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; XOP-NEXT:    vpaddq %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpaddq %xmm2, %xmm5, %xmm2
; XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_signed_mem_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtq %zmm0, %zmm1, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminsq %zmm0, %zmm1, %zmm2
; AVX512F-NEXT:    vpmaxsq %zmm0, %zmm1, %zmm0
; AVX512F-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlq $1, %ymm0, %ymm2
; AVX512F-NEXT:    vpsrlq $33, %ymm0, %ymm0
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512F-NEXT:    vpaddq %ymm0, %ymm4, %ymm0
; AVX512F-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX512F-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_signed_mem_reg:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-NEXT:    vpcmpgtq %ymm0, %ymm1, %k1
; AVX512VL-NEXT:    vpminsq %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpmaxsq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlq $1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpsubq %ymm0, %ymm2, %ymm0 {%k1}
; AVX512VL-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_signed_mem_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtq %zmm0, %zmm1, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsq %zmm0, %zmm1, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsq %zmm0, %zmm1, %zmm0
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $33, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm4, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %a1 = load <4 x i64>, ptr %a1_addr
  %t3 = icmp sgt <4 x i64> %a1, %a2 ; signed
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul nsw <4 x i64> %t8, %t4 ; signed
  %a10 = add nsw <4 x i64> %t9, %a1 ; signed
  ret <4 x i64> %a10
}

define <4 x i64> @vec256_i64_signed_reg_mem(<4 x i64> %a1, ptr %a2_addr) nounwind {
; AVX1-LABEL: vec256_i64_signed_reg_mem:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm6
; AVX1-NEXT:    vpsrlq $1, %xmm1, %xmm7
; AVX1-NEXT:    vpsrlq $33, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; AVX1-NEXT:    vpor %xmm5, %xmm8, %xmm9
; AVX1-NEXT:    vpmuludq %xmm1, %xmm9, %xmm1
; AVX1-NEXT:    vpsrlq $32, %xmm5, %xmm5
; AVX1-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpaddq %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; AVX1-NEXT:    vpsrlq $33, %xmm2, %xmm2
; AVX1-NEXT:    vpor %xmm4, %xmm8, %xmm7
; AVX1-NEXT:    vpmuludq %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq $32, %xmm4, %xmm4
; AVX1-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpaddq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsllq $32, %xmm2, %xmm2
; AVX1-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; AVX1-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_signed_reg_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm4
; AVX2-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i64_signed_reg_mem:
; XOP:       # %bb.0:
; XOP-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtq %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpsubq %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; XOP-NEXT:    vpsubq %xmm1, %xmm5, %xmm1
; XOP-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpxor %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpsubq %xmm2, %xmm4, %xmm2
; XOP-NEXT:    vpsrlq $1, %xmm2, %xmm6
; XOP-NEXT:    vpsrlq $1, %xmm1, %xmm7
; XOP-NEXT:    vpsrlq $33, %xmm1, %xmm1
; XOP-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; XOP-NEXT:    vpor %xmm5, %xmm8, %xmm9
; XOP-NEXT:    vpmuludq %xmm1, %xmm9, %xmm1
; XOP-NEXT:    vpsrlq $32, %xmm5, %xmm5
; XOP-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; XOP-NEXT:    vpaddq %xmm1, %xmm5, %xmm1
; XOP-NEXT:    vpsllq $32, %xmm1, %xmm1
; XOP-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; XOP-NEXT:    vpsrlq $33, %xmm2, %xmm2
; XOP-NEXT:    vpor %xmm4, %xmm8, %xmm7
; XOP-NEXT:    vpmuludq %xmm7, %xmm2, %xmm2
; XOP-NEXT:    vpsrlq $32, %xmm4, %xmm4
; XOP-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm2, %xmm4, %xmm2
; XOP-NEXT:    vpsllq $32, %xmm2, %xmm2
; XOP-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; XOP-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; XOP-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_signed_reg_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512F-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $1, %ymm1, %ymm2
; AVX512F-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512F-NEXT:    vpaddq %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_signed_reg_mem:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-NEXT:    vpcmpgtq %ymm1, %ymm0, %k1
; AVX512VL-NEXT:    vpminsq %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpsubq %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_signed_reg_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm4, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %a2 = load <4 x i64>, ptr %a2_addr
  %t3 = icmp sgt <4 x i64> %a1, %a2 ; signed
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul nsw <4 x i64> %t8, %t4 ; signed
  %a10 = add nsw <4 x i64> %t9, %a1 ; signed
  ret <4 x i64> %a10
}

define <4 x i64> @vec256_i64_signed_mem_mem(ptr %a1_addr, ptr %a2_addr) nounwind {
; AVX1-LABEL: vec256_i64_signed_mem_mem:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rsi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX1-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpsubq %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpxor %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpsubq %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpsrlq $1, %xmm1, %xmm6
; AVX1-NEXT:    vpsrlq $1, %xmm0, %xmm7
; AVX1-NEXT:    vpsrlq $33, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; AVX1-NEXT:    vpor %xmm5, %xmm8, %xmm9
; AVX1-NEXT:    vpmuludq %xmm0, %xmm9, %xmm0
; AVX1-NEXT:    vpsrlq $32, %xmm5, %xmm5
; AVX1-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX1-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; AVX1-NEXT:    vpsrlq $33, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm4, %xmm8, %xmm7
; AVX1-NEXT:    vpmuludq %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlq $32, %xmm4, %xmm4
; AVX1-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpaddq %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; AVX1-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpaddq %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpaddq %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_signed_mem_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm4
; AVX2-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i64_signed_mem_mem:
; XOP:       # %bb.0:
; XOP-NEXT:    vmovdqa (%rsi), %xmm0
; XOP-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOP-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-NEXT:    vpcomgtq %xmm1, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtq %xmm0, %xmm2, %xmm5
; XOP-NEXT:    vpsubq %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vpxor %xmm5, %xmm0, %xmm0
; XOP-NEXT:    vpsubq %xmm0, %xmm5, %xmm0
; XOP-NEXT:    vpsubq %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpxor %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpsubq %xmm1, %xmm4, %xmm1
; XOP-NEXT:    vpsrlq $1, %xmm1, %xmm6
; XOP-NEXT:    vpsrlq $1, %xmm0, %xmm7
; XOP-NEXT:    vpsrlq $33, %xmm0, %xmm0
; XOP-NEXT:    vpmovsxbq {{.*#+}} xmm8 = [1,1]
; XOP-NEXT:    vpor %xmm5, %xmm8, %xmm9
; XOP-NEXT:    vpmuludq %xmm0, %xmm9, %xmm0
; XOP-NEXT:    vpsrlq $32, %xmm5, %xmm5
; XOP-NEXT:    vpmuludq %xmm5, %xmm7, %xmm5
; XOP-NEXT:    vpaddq %xmm0, %xmm5, %xmm0
; XOP-NEXT:    vpsllq $32, %xmm0, %xmm0
; XOP-NEXT:    vpmuludq %xmm7, %xmm9, %xmm5
; XOP-NEXT:    vpsrlq $33, %xmm1, %xmm1
; XOP-NEXT:    vpor %xmm4, %xmm8, %xmm7
; XOP-NEXT:    vpmuludq %xmm7, %xmm1, %xmm1
; XOP-NEXT:    vpsrlq $32, %xmm4, %xmm4
; XOP-NEXT:    vpmuludq %xmm4, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm1, %xmm4, %xmm1
; XOP-NEXT:    vpsllq $32, %xmm1, %xmm1
; XOP-NEXT:    vpmuludq %xmm7, %xmm6, %xmm4
; XOP-NEXT:    vpaddq %xmm3, %xmm4, %xmm3
; XOP-NEXT:    vpaddq %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpaddq %xmm2, %xmm5, %xmm2
; XOP-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_signed_mem_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512F-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $1, %ymm1, %ymm2
; AVX512F-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512F-NEXT:    vpaddq %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_signed_mem_mem:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VL-NEXT:    vpcmpgtq %ymm1, %ymm0, %k1
; AVX512VL-NEXT:    vpminsq %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpsubq %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_signed_mem_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $33, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm2, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm4, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %a1 = load <4 x i64>, ptr %a1_addr
  %a2 = load <4 x i64>, ptr %a2_addr
  %t3 = icmp sgt <4 x i64> %a1, %a2 ; signed
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul nsw <4 x i64> %t8, %t4 ; signed
  %a10 = add nsw <4 x i64> %t9, %a1 ; signed
  ret <4 x i64> %a10
}

; ---------------------------------------------------------------------------- ;
; 16-bit width. 256 / 16 = 16 elts.
; ---------------------------------------------------------------------------- ;

; Values come from regs

define <16 x i16> @vec256_i16_signed_reg_reg(<16 x i16> %a1, <16 x i16> %a2) nounwind {
; AVX1-LABEL: vec256_i16_signed_reg_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpminsw %xmm1, %xmm0, %xmm6
; AVX1-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpminsw %xmm2, %xmm3, %xmm6
; AVX1-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubw %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpmullw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_signed_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i16_signed_reg_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtw %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtw %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpminsw %xmm2, %xmm3, %xmm6
; XOP-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpsubw %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpminsw %xmm1, %xmm0, %xmm6
; XOP-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_signed_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_signed_reg_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm2, %ymm3, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpxor %ymm1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm1, %ymm2, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_signed_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpgtw %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_signed_reg_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpgtw %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubw %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %t3 = icmp sgt <16 x i16> %a1, %a2 ; signed
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul nsw <16 x i16> %t16, %t4 ; signed
  %a10 = add nsw <16 x i16> %t9, %a1 ; signed
  ret <16 x i16> %a10
}

define <16 x i16> @vec256_i16_unsigned_reg_reg(<16 x i16> %a1, <16 x i16> %a2) nounwind {
; AVX1-LABEL: vec256_i16_unsigned_reg_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpminuw %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpeqw %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpxor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpminuw %xmm1, %xmm0, %xmm7
; AVX1-NEXT:    vpcmpeqw %xmm7, %xmm0, %xmm8
; AVX1-NEXT:    vpxor %xmm6, %xmm8, %xmm6
; AVX1-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsubw %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpmaxuw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm4, %xmm6, %xmm6
; AVX1-NEXT:    vpmullw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpmullw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_unsigned_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i16_unsigned_reg_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtuw %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtuw %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpminuw %xmm2, %xmm3, %xmm6
; XOP-NEXT:    vpmaxuw %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpsubw %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpminuw %xmm1, %xmm0, %xmm6
; XOP-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_unsigned_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm3
; AVX512F-NEXT:    vpternlogq {{.*#+}} zmm3 = ~zmm3
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX512F-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_unsigned_reg_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpternlogq {{.*#+}} ymm2 = ~ymm2
; AVX512VL-FALLBACK-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_unsigned_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_unsigned_reg_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpnleuw %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubw %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %t3 = icmp ugt <16 x i16> %a1, %a2
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul <16 x i16> %t16, %t4
  %a10 = add <16 x i16> %t9, %a1
  ret <16 x i16> %a10
}

; Values are loaded. Only check signed case.

define <16 x i16> @vec256_i16_signed_mem_reg(ptr %a1_addr, <16 x i16> %a2) nounwind {
; AVX1-LABEL: vec256_i16_signed_mem_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpminsw %xmm0, %xmm2, %xmm6
; AVX1-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsubw %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpminsw %xmm1, %xmm3, %xmm6
; AVX1-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpmullw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_signed_mem_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsw %ymm0, %ymm1, %ymm3
; AVX2-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i16_signed_mem_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOP-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-NEXT:    vpcomgtw %xmm1, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtw %xmm0, %xmm2, %xmm5
; XOP-NEXT:    vpminsw %xmm1, %xmm3, %xmm6
; XOP-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpminsw %xmm0, %xmm2, %xmm6
; XOP-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vpsubw %xmm6, %xmm0, %xmm0
; XOP-NEXT:    vpsrlw $1, %xmm0, %xmm0
; XOP-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpmacsww %xmm3, %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpmacsww %xmm2, %xmm5, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_signed_mem_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm2
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsw %ymm0, %ymm1, %ymm3
; AVX512F-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_signed_mem_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpminsw %ymm0, %ymm1, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm2, %ymm3, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpxor %ymm0, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm0, %ymm2, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_signed_mem_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtw %zmm0, %zmm1, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsw %ymm0, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_signed_mem_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtw %ymm0, %ymm1, %k1
; AVX512VLBW-NEXT:    vpminsw %ymm0, %ymm1, %ymm2
; AVX512VLBW-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubw %ymm0, %ymm2, %ymm0 {%k1}
; AVX512VLBW-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
  %a1 = load <16 x i16>, ptr %a1_addr
  %t3 = icmp sgt <16 x i16> %a1, %a2 ; signed
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul nsw <16 x i16> %t16, %t4 ; signed
  %a10 = add nsw <16 x i16> %t9, %a1 ; signed
  ret <16 x i16> %a10
}

define <16 x i16> @vec256_i16_signed_reg_mem(<16 x i16> %a1, ptr %a2_addr) nounwind {
; AVX1-LABEL: vec256_i16_signed_reg_mem:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpgtw %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpminsw %xmm1, %xmm0, %xmm6
; AVX1-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpminsw %xmm2, %xmm3, %xmm6
; AVX1-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubw %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpmullw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_signed_reg_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i16_signed_reg_mem:
; XOP:       # %bb.0:
; XOP-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtw %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtw %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpminsw %xmm2, %xmm3, %xmm6
; XOP-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpsubw %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpminsw %xmm1, %xmm0, %xmm6
; XOP-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_signed_reg_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_signed_reg_mem:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm2, %ymm3, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpxor %ymm1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm1, %ymm2, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_signed_reg_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtw %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_signed_reg_mem:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtw %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubw %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %a2 = load <16 x i16>, ptr %a2_addr
  %t3 = icmp sgt <16 x i16> %a1, %a2 ; signed
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul nsw <16 x i16> %t16, %t4 ; signed
  %a10 = add nsw <16 x i16> %t9, %a1 ; signed
  ret <16 x i16> %a10
}

define <16 x i16> @vec256_i16_signed_mem_mem(ptr %a1_addr, ptr %a2_addr) nounwind {
; AVX1-LABEL: vec256_i16_signed_mem_mem:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rsi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX1-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-NEXT:    vpcmpgtw %xmm1, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtw %xmm0, %xmm2, %xmm5
; AVX1-NEXT:    vpminsw %xmm0, %xmm2, %xmm6
; AVX1-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsubw %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpminsw %xmm1, %xmm3, %xmm6
; AVX1-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpmullw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_signed_mem_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i16_signed_mem_mem:
; XOP:       # %bb.0:
; XOP-NEXT:    vmovdqa (%rsi), %xmm0
; XOP-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOP-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-NEXT:    vpcomgtw %xmm1, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtw %xmm0, %xmm2, %xmm5
; XOP-NEXT:    vpminsw %xmm1, %xmm3, %xmm6
; XOP-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpminsw %xmm0, %xmm2, %xmm6
; XOP-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vpsubw %xmm6, %xmm0, %xmm0
; XOP-NEXT:    vpsrlw $1, %xmm0, %xmm0
; XOP-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpmacsww %xmm3, %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpmacsww %xmm2, %xmm5, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_signed_mem_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_signed_mem_mem:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm2, %ymm3, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpxor %ymm1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm1, %ymm2, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_signed_mem_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtw %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_signed_mem_mem:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VLBW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtw %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubw %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %a1 = load <16 x i16>, ptr %a1_addr
  %a2 = load <16 x i16>, ptr %a2_addr
  %t3 = icmp sgt <16 x i16> %a1, %a2 ; signed
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul nsw <16 x i16> %t16, %t4 ; signed
  %a10 = add nsw <16 x i16> %t9, %a1 ; signed
  ret <16 x i16> %a10
}

; ---------------------------------------------------------------------------- ;
; 8-bit width. 256 / 8 = 32 elts.
; ---------------------------------------------------------------------------- ;

; Values come from regs

define <32 x i8> @vec256_i8_signed_reg_reg(<32 x i8> %a1, <32 x i8> %a2) nounwind {
; AVX1-LABEL: vec256_i8_signed_reg_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpminsb %xmm1, %xmm0, %xmm6
; AVX1-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpminsb %xmm3, %xmm2, %xmm6
; AVX1-NEXT:    vpmaxsb %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpsubb %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm8
; AVX1-NEXT:    vpmaddubsw %xmm8, %xmm1, %xmm8
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm8
; AVX1-NEXT:    vpandn %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsllw $8, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm1, %xmm8, %xmm1
; AVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpandn %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpmaddubsw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_signed_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpmaddubsw %ymm4, %ymm1, %ymm4
; AVX2-NEXT:    vpand %ymm3, %ymm4, %ymm4
; AVX2-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i8_signed_reg_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtb %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtb %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpminsb %xmm1, %xmm0, %xmm6
; XOP-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; XOP-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; XOP-NEXT:    vpandn %xmm5, %xmm7, %xmm8
; XOP-NEXT:    vpmaddubsw %xmm8, %xmm1, %xmm8
; XOP-NEXT:    vpand %xmm7, %xmm5, %xmm5
; XOP-NEXT:    vpmaddubsw %xmm5, %xmm1, %xmm1
; XOP-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,16,2,18,4,20,6,22,8,24,10,26,12,28,14,30]
; XOP-NEXT:    vpperm %xmm5, %xmm8, %xmm1, %xmm1
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpandn %xmm4, %xmm7, %xmm6
; XOP-NEXT:    vpmaddubsw %xmm6, %xmm2, %xmm6
; XOP-NEXT:    vpand %xmm7, %xmm4, %xmm4
; XOP-NEXT:    vpmaddubsw %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpperm %xmm5, %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_signed_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpmaddubsw %ymm4, %ymm1, %ymm4
; AVX512F-NEXT:    vpand %ymm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_signed_reg_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm2, %ymm3, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpternlogd {{.*#+}} ymm2 = ymm1 ^ (ymm2 & m32bcst)
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm1, %ymm2, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_signed_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpgtb %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_signed_reg_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpgtb %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubb %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %t3 = icmp sgt <32 x i8> %a1, %a2 ; signed
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul nsw <32 x i8> %t8, %t4 ; signed
  %a10 = add nsw <32 x i8> %t9, %a1 ; signed
  ret <32 x i8> %a10
}

define <32 x i8> @vec256_i8_unsigned_reg_reg(<32 x i8> %a1, <32 x i8> %a2) nounwind {
; AVX1-LABEL: vec256_i8_unsigned_reg_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpminub %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpxor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm7
; AVX1-NEXT:    vpcmpeqb %xmm7, %xmm0, %xmm8
; AVX1-NEXT:    vpxor %xmm6, %xmm8, %xmm6
; AVX1-NEXT:    vpmaxub %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpmaxub %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpsubb %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm4, %xmm6, %xmm6
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm6, %xmm8
; AVX1-NEXT:    vpmaddubsw %xmm8, %xmm1, %xmm8
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm8
; AVX1-NEXT:    vpandn %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vpmaddubsw %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpsllw $8, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm1, %xmm8, %xmm1
; AVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpandn %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpmaddubsw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_unsigned_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm2, %ymm3, %ymm4
; AVX2-NEXT:    vpmaddubsw %ymm4, %ymm1, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm4
; AVX2-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i8_unsigned_reg_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtub %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtub %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpminub %xmm1, %xmm0, %xmm6
; XOP-NEXT:    vpmaxub %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpminub %xmm2, %xmm3, %xmm6
; XOP-NEXT:    vpmaxub %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; XOP-NEXT:    vpandn %xmm5, %xmm7, %xmm8
; XOP-NEXT:    vpmaddubsw %xmm8, %xmm1, %xmm8
; XOP-NEXT:    vpand %xmm7, %xmm5, %xmm5
; XOP-NEXT:    vpmaddubsw %xmm5, %xmm1, %xmm1
; XOP-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,16,2,18,4,20,6,22,8,24,10,26,12,28,14,30]
; XOP-NEXT:    vpperm %xmm5, %xmm8, %xmm1, %xmm1
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpandn %xmm4, %xmm7, %xmm6
; XOP-NEXT:    vpmaddubsw %xmm6, %xmm2, %xmm6
; XOP-NEXT:    vpand %xmm7, %xmm4, %xmm4
; XOP-NEXT:    vpmaddubsw %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpperm %xmm5, %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_unsigned_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm3
; AVX512F-NEXT:    vpternlogq {{.*#+}} zmm3 = ~zmm3
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm3, %ymm3
; AVX512F-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm2, %ymm3, %ymm4
; AVX512F-NEXT:    vpmaddubsw %ymm4, %ymm1, %ymm4
; AVX512F-NEXT:    vpand %ymm2, %ymm4, %ymm4
; AVX512F-NEXT:    vpandn %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_unsigned_reg_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpternlogq {{.*#+}} ymm2 = ~ymm2
; AVX512VL-FALLBACK-NEXT:    vpternlogd {{.*#+}} ymm1 = ymm2 ^ (ymm1 & m32bcst)
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_unsigned_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpnleub %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_unsigned_reg_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpnleub %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubb %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %t3 = icmp ugt <32 x i8> %a1, %a2
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul <32 x i8> %t8, %t4
  %a10 = add <32 x i8> %t9, %a1
  ret <32 x i8> %a10
}

; Values are loaded. Only check signed case.

define <32 x i8> @vec256_i8_signed_mem_reg(ptr %a1_addr, <32 x i8> %a2) nounwind {
; AVX1-LABEL: vec256_i8_signed_mem_reg:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm2, %xmm4
; AVX1-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm5
; AVX1-NEXT:    vpminsb %xmm0, %xmm1, %xmm6
; AVX1-NEXT:    vpmaxsb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsubb %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpminsb %xmm3, %xmm2, %xmm6
; AVX1-NEXT:    vpmaxsb %xmm3, %xmm2, %xmm3
; AVX1-NEXT:    vpsubb %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm8
; AVX1-NEXT:    vpmaddubsw %xmm8, %xmm0, %xmm8
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm8
; AVX1-NEXT:    vpandn %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $8, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm0, %xmm8, %xmm0
; AVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpandn %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpmaddubsw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_signed_mem_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsb %ymm0, %ymm1, %ymm3
; AVX2-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpmaddubsw %ymm4, %ymm0, %ymm4
; AVX2-NEXT:    vpand %ymm3, %ymm4, %ymm4
; AVX2-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpmaddubsw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $8, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i8_signed_mem_reg:
; XOP:       # %bb.0:
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOP-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-NEXT:    vpcomgtb %xmm1, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtb %xmm0, %xmm2, %xmm5
; XOP-NEXT:    vpminsb %xmm0, %xmm2, %xmm6
; XOP-NEXT:    vpmaxsb %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vpsubb %xmm6, %xmm0, %xmm0
; XOP-NEXT:    vpminsb %xmm1, %xmm3, %xmm6
; XOP-NEXT:    vpmaxsb %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpshlb %xmm6, %xmm0, %xmm0
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; XOP-NEXT:    vpandn %xmm5, %xmm7, %xmm8
; XOP-NEXT:    vpmaddubsw %xmm8, %xmm0, %xmm8
; XOP-NEXT:    vpand %xmm7, %xmm5, %xmm5
; XOP-NEXT:    vpmaddubsw %xmm5, %xmm0, %xmm0
; XOP-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,16,2,18,4,20,6,22,8,24,10,26,12,28,14,30]
; XOP-NEXT:    vpperm %xmm5, %xmm8, %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpandn %xmm4, %xmm7, %xmm6
; XOP-NEXT:    vpmaddubsw %xmm6, %xmm1, %xmm6
; XOP-NEXT:    vpand %xmm7, %xmm4, %xmm4
; XOP-NEXT:    vpmaddubsw %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpperm %xmm5, %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; XOP-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_signed_mem_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm2
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsb %ymm0, %ymm1, %ymm3
; AVX512F-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpmaddubsw %ymm4, %ymm0, %ymm4
; AVX512F-NEXT:    vpand %ymm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpmaddubsw %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllw $8, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm0, %ymm4, %ymm0
; AVX512F-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_signed_mem_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpminsb %ymm0, %ymm1, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm2, %ymm3, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpternlogd {{.*#+}} ymm2 = ymm0 ^ (ymm2 & m32bcst)
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm0, %ymm2, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_signed_mem_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtb %zmm0, %zmm1, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsb %ymm0, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm0, %zmm0
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_signed_mem_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtb %ymm0, %ymm1, %k1
; AVX512VLBW-NEXT:    vpminsb %ymm0, %ymm1, %ymm2
; AVX512VLBW-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubb %ymm0, %ymm2, %ymm0 {%k1}
; AVX512VLBW-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
  %a1 = load <32 x i8>, ptr %a1_addr
  %t3 = icmp sgt <32 x i8> %a1, %a2 ; signed
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul nsw <32 x i8> %t8, %t4 ; signed
  %a10 = add nsw <32 x i8> %t9, %a1 ; signed
  ret <32 x i8> %a10
}

define <32 x i8> @vec256_i8_signed_reg_mem(<32 x i8> %a1, ptr %a2_addr) nounwind {
; AVX1-LABEL: vec256_i8_signed_reg_mem:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpcmpgtb %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpminsb %xmm2, %xmm0, %xmm6
; AVX1-NEXT:    vpmaxsb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpminsb %xmm3, %xmm1, %xmm6
; AVX1-NEXT:    vpmaxsb %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpsubb %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm8
; AVX1-NEXT:    vpmaddubsw %xmm8, %xmm2, %xmm8
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm8
; AVX1-NEXT:    vpandn %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm2
; AVX1-NEXT:    vpor %xmm2, %xmm8, %xmm2
; AVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm3, %xmm5
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpandn %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpmaddubsw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsllw $8, %xmm3, %xmm3
; AVX1-NEXT:    vpor %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpaddb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_signed_reg_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpmaddubsw %ymm4, %ymm1, %ymm4
; AVX2-NEXT:    vpand %ymm3, %ymm4, %ymm4
; AVX2-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i8_signed_reg_mem:
; XOP:       # %bb.0:
; XOP-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-NEXT:    vpcomgtb %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtb %xmm1, %xmm0, %xmm5
; XOP-NEXT:    vpminsb %xmm1, %xmm0, %xmm6
; XOP-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; XOP-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; XOP-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; XOP-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; XOP-NEXT:    vpandn %xmm5, %xmm7, %xmm8
; XOP-NEXT:    vpmaddubsw %xmm8, %xmm1, %xmm8
; XOP-NEXT:    vpand %xmm7, %xmm5, %xmm5
; XOP-NEXT:    vpmaddubsw %xmm5, %xmm1, %xmm1
; XOP-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,16,2,18,4,20,6,22,8,24,10,26,12,28,14,30]
; XOP-NEXT:    vpperm %xmm5, %xmm8, %xmm1, %xmm1
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpandn %xmm4, %xmm7, %xmm6
; XOP-NEXT:    vpmaddubsw %xmm6, %xmm2, %xmm6
; XOP-NEXT:    vpand %xmm7, %xmm4, %xmm4
; XOP-NEXT:    vpmaddubsw %xmm4, %xmm2, %xmm2
; XOP-NEXT:    vpperm %xmm5, %xmm6, %xmm2, %xmm2
; XOP-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_signed_reg_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpmaddubsw %ymm4, %ymm1, %ymm4
; AVX512F-NEXT:    vpand %ymm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_signed_reg_mem:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm2, %ymm3, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpternlogd {{.*#+}} ymm2 = ymm1 ^ (ymm2 & m32bcst)
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm1, %ymm2, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_signed_reg_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtb %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_signed_reg_mem:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtb %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubb %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %a2 = load <32 x i8>, ptr %a2_addr
  %t3 = icmp sgt <32 x i8> %a1, %a2 ; signed
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul nsw <32 x i8> %t8, %t4 ; signed
  %a10 = add nsw <32 x i8> %t9, %a1 ; signed
  ret <32 x i8> %a10
}

define <32 x i8> @vec256_i8_signed_mem_mem(ptr %a1_addr, ptr %a2_addr) nounwind {
; AVX1-LABEL: vec256_i8_signed_mem_mem:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rsi), %xmm1
; AVX1-NEXT:    vmovdqa 16(%rsi), %xmm2
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-NEXT:    vpcmpgtb %xmm2, %xmm3, %xmm4
; AVX1-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm5
; AVX1-NEXT:    vpminsb %xmm1, %xmm0, %xmm6
; AVX1-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; AVX1-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm8
; AVX1-NEXT:    vpmaddubsw %xmm8, %xmm1, %xmm8
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm8
; AVX1-NEXT:    vpandn %xmm5, %xmm7, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsllw $8, %xmm1, %xmm1
; AVX1-NEXT:    vpor %xmm1, %xmm8, %xmm1
; AVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm5
; AVX1-NEXT:    vpmaddubsw %xmm5, %xmm2, %xmm5
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpandn %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpmaddubsw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $8, %xmm2, %xmm2
; AVX1-NEXT:    vpor %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_signed_mem_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpmaddubsw %ymm4, %ymm1, %ymm4
; AVX2-NEXT:    vpand %ymm3, %ymm4, %ymm4
; AVX2-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-LABEL: vec256_i8_signed_mem_mem:
; XOP:       # %bb.0:
; XOP-NEXT:    vmovdqa (%rsi), %xmm0
; XOP-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOP-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-NEXT:    vpcomgtb %xmm1, %xmm3, %xmm4
; XOP-NEXT:    vpcomgtb %xmm0, %xmm2, %xmm5
; XOP-NEXT:    vpminsb %xmm0, %xmm2, %xmm6
; XOP-NEXT:    vpmaxsb %xmm0, %xmm2, %xmm0
; XOP-NEXT:    vpsubb %xmm6, %xmm0, %xmm0
; XOP-NEXT:    vpminsb %xmm1, %xmm3, %xmm6
; XOP-NEXT:    vpmaxsb %xmm1, %xmm3, %xmm1
; XOP-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpshlb %xmm6, %xmm0, %xmm0
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-NEXT:    vbroadcastss {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; XOP-NEXT:    vpandn %xmm5, %xmm7, %xmm8
; XOP-NEXT:    vpmaddubsw %xmm8, %xmm0, %xmm8
; XOP-NEXT:    vpand %xmm7, %xmm5, %xmm5
; XOP-NEXT:    vpmaddubsw %xmm5, %xmm0, %xmm0
; XOP-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,16,2,18,4,20,6,22,8,24,10,26,12,28,14,30]
; XOP-NEXT:    vpperm %xmm5, %xmm8, %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-NEXT:    vpandn %xmm4, %xmm7, %xmm6
; XOP-NEXT:    vpmaddubsw %xmm6, %xmm1, %xmm6
; XOP-NEXT:    vpand %xmm7, %xmm4, %xmm4
; XOP-NEXT:    vpmaddubsw %xmm4, %xmm1, %xmm1
; XOP-NEXT:    vpperm %xmm5, %xmm6, %xmm1, %xmm1
; XOP-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; XOP-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; XOP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_signed_mem_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpbroadcastw {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpmaddubsw %ymm4, %ymm1, %ymm4
; AVX512F-NEXT:    vpand %ymm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpandn %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpmaddubsw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsllw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_signed_mem_mem:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm2, %ymm3, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpternlogd {{.*#+}} ymm2 = ymm1 ^ (ymm2 & m32bcst)
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm1, %ymm2, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_signed_mem_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtb %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastb {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_signed_mem_mem:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VLBW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtb %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubb %ymm1, %ymm2, %ymm1 {%k1}
; AVX512VLBW-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %a1 = load <32 x i8>, ptr %a1_addr
  %a2 = load <32 x i8>, ptr %a2_addr
  %t3 = icmp sgt <32 x i8> %a1, %a2 ; signed
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul nsw <32 x i8> %t8, %t4 ; signed
  %a10 = add nsw <32 x i8> %t9, %a1 ; signed
  ret <32 x i8> %a10
}
