; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mcpu=generic -mtriple=i686-- | FileCheck %s
	%struct._obstack_chunk = type { ptr, ptr, [4 x i8] }
	%struct.obstack = type { i32, ptr, ptr, ptr, ptr, i32, i32, ptr, ptr, ptr, i8 }
@stmt_obstack = external dso_local global %struct.obstack		; <ptr> [#uses=1]

; This should just not crash.
define void @test1() nounwind {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testb $1, stmt_obstack+40
; CHECK-NEXT:    jne .LBB0_1
; CHECK-NEXT:  # %bb.2: # %cond_false30.i
; CHECK-NEXT:    pushl $0
; CHECK-NEXT:    calll 0
; CHECK-NEXT:    addl $4, %esp
; CHECK-NEXT:    retl
; CHECK-NEXT:  .LBB0_1: # %cond_true23.i
; CHECK-NEXT:    retl
entry:
	br i1 true, label %cond_true, label %cond_next

cond_true:		; preds = %entry
	%new_size.0.i = select i1 false, i32 0, i32 0		; <i32> [#uses=1]
	%tmp.i = load i32, ptr getelementptr (%struct.obstack, ptr @stmt_obstack, i32 0, i32 10)		; <i32> [#uses=1]
	%tmp.i.upgrd.1 = trunc i32 %tmp.i to i8		; <i8> [#uses=1]
	%tmp21.i = and i8 %tmp.i.upgrd.1, 1		; <i8> [#uses=1]
	%tmp22.i = icmp eq i8 %tmp21.i, 0		; <i1> [#uses=1]
	br i1 %tmp22.i, label %cond_false30.i, label %cond_true23.i

cond_true23.i:		; preds = %cond_true
	ret void

cond_false30.i:		; preds = %cond_true
	%tmp35.i = tail call ptr null( i32 %new_size.0.i )		; <ptr> [#uses=0]
	ret void

cond_next:		; preds = %entry
	ret void
}



define i32 @test2(ptr %P, ptr %Q) nounwind {
; CHECK-LABEL: test2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movzwl (%eax), %edx
; CHECK-NEXT:    movzbl %dl, %eax
; CHECK-NEXT:    movw %dx, (%ecx)
; CHECK-NEXT:    retl
  %A = load i16, ptr %P, align 4                      ; <i16> [#uses=11]
  %C = zext i16 %A to i32                         ; <i32> [#uses=1]
  %D = and i32 %C, 255                            ; <i32> [#uses=1]
  br label %L
L:

  store i16 %A, ptr %Q
  ret i32 %D


}

; rdar://10554090
; xor in exit block will be CSE'ed and load will be folded to xor in entry.
define i1 @test3(ptr %P, ptr %Q) nounwind {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-NEXT:    movl (%eax), %eax
; CHECK-NEXT:    xorl (%ecx), %eax
; CHECK-NEXT:    testl $89947, %eax # imm = 0x15F5B
; CHECK-NEXT:    je .LBB2_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retl
; CHECK-NEXT:  .LBB2_2: # %exit
; CHECK-NEXT:    testl $-838178173, %eax # imm = 0xCE0A6A83
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retl
entry:
  %0 = load i32, ptr %P, align 4
  %1 = load i32, ptr %Q, align 4
  %2 = xor i32 %0, %1
  %3 = and i32 %2, 89947
  %4 = icmp eq i32 %3, 0
  br i1 %4, label %exit, label %land.end

exit:
  %shr.i.i19 = xor i32 %1, %0
  %5 = and i32 %shr.i.i19, 3456789123
  %6 = icmp eq i32 %5, 0
  br label %land.end

land.end:
  %7 = phi i1 [ %6, %exit ], [ false, %entry ]
  ret i1 %7
}
