; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-attributes --check-globals --version 2
; RUN: opt -S -passes=attributor < %s | FileCheck %s

; Keep the attribute checks clean by disabling inference of anything else.
declare void @call_of_mystery()

; Should infer to ieee,ieee/default
define internal void @leaf_dynamic_dynamic_from_ieee_ieee() #0 {
; CHECK-LABEL: define internal void @leaf_dynamic_dynamic_from_ieee_ieee() {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Should infer to ieee,ieee/default
define internal void @leaf_recursive_dynamic_dynamic_from_ieee_ieee() #0 {
; CHECK-LABEL: define internal void @leaf_recursive_dynamic_dynamic_from_ieee_ieee() {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    call void @leaf_recursive_dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  call void @leaf_recursive_dynamic_dynamic_from_ieee_ieee()
  ret void
}

; Should strip denormal-fp-math for default ieee
define internal void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_ieee_ieee() #1 {
; CHECK-LABEL: define internal void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_ieee_ieee() {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Should infer to preserve-sign,preserve-sign
define internal void @leaf_dynamic_dynamic_from_daz_daz() #0 {
; CHECK-LABEL: define internal void @leaf_dynamic_dynamic_from_daz_daz
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; This goes to invalid because of the mismatch in the main mode. We
; could theoretically refine to denormal-fp-math-f32=preserve-sign,preserve-sign
define internal void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz() #1 {
; CHECK-LABEL: define internal void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz
; CHECK-SAME: () #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Leave this alone, must stay dynamic,dynamic
define internal void @leaf_dynamic_dynamic_from_daz_daz_and_ieee_ieee() #0 {
; CHECK-LABEL: define internal void @leaf_dynamic_dynamic_from_daz_daz_and_ieee_ieee
; CHECK-SAME: () #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Leave this alone, should only have denormal-fp-math-f32=ieee,ieee
define internal void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz_and_ieee_ieee() #1 {
; CHECK-LABEL: define internal void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz_and_ieee_ieee
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Leave as dynamic,dynamic
define void @externally_visible_dynamic_dynamic_from_ieee_ieee() #0 {
; CHECK-LABEL: define void @externally_visible_dynamic_dynamic_from_ieee_ieee
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Should infer to positive-zero,positive-zero
define internal void @leaf_dynamic_dynamic_from_dapz_dapz() #0 {
; CHECK-LABEL: define internal void @leaf_dynamic_dynamic_from_dapz_dapz
; CHECK-SAME: () #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; ieee,ieee entry point
define void @func_ieee_ieee() #2 {
; CHECK-LABEL: define void @func_ieee_ieee() {
; CHECK-NEXT:    call void @leaf_dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_dynamic_dynamic_from_daz_daz_and_ieee_ieee()
; CHECK-NEXT:    call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz_and_ieee_ieee()
; CHECK-NEXT:    call void @externally_visible_dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_dynamic_ieee_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_ieee_dynamic_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_recursive_dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    ret void
;
  call void @leaf_dynamic_dynamic_from_ieee_ieee()
  call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_ieee_ieee()
  call void @leaf_dynamic_dynamic_from_daz_daz_and_ieee_ieee()
  call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz_and_ieee_ieee()
  call void @externally_visible_dynamic_dynamic_from_ieee_ieee()
  call void @leaf_dynamic_ieee_from_ieee_ieee()
  call void @leaf_ieee_dynamic_from_ieee_ieee()
  call void @leaf_recursive_dynamic_dynamic_from_ieee_ieee()
  ret void
}

; ieee,ieee entry point
define void @func_default_is_ieee_ieee() {
; CHECK-LABEL: define void @func_default_is_ieee_ieee() {
; CHECK-NEXT:    call void @leaf_dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_dynamic_dynamic_from_daz_daz_and_ieee_ieee()
; CHECK-NEXT:    call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz_and_ieee_ieee()
; CHECK-NEXT:    call void @externally_visible_dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_dynamic_ieee_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_ieee_dynamic_from_ieee_ieee()
; CHECK-NEXT:    call void @leaf_recursive_dynamic_dynamic_from_ieee_ieee()
; CHECK-NEXT:    ret void
;
  call void @leaf_dynamic_dynamic_from_ieee_ieee()
  call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_ieee_ieee()
  call void @leaf_dynamic_dynamic_from_daz_daz_and_ieee_ieee()
  call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz_and_ieee_ieee()
  call void @externally_visible_dynamic_dynamic_from_ieee_ieee()
  call void @leaf_dynamic_ieee_from_ieee_ieee()
  call void @leaf_ieee_dynamic_from_ieee_ieee()
  call void @leaf_recursive_dynamic_dynamic_from_ieee_ieee()
  ret void
}

; preserve-sign,preserve-sign entry point
define void @func_daz_daz() #3 {
; CHECK-LABEL: define void @func_daz_daz
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:    call void @leaf_dynamic_dynamic_from_daz_daz()
; CHECK-NEXT:    call void @leaf_dynamic_dynamic_from_daz_daz_and_ieee_ieee()
; CHECK-NEXT:    call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz_and_ieee_ieee()
; CHECK-NEXT:    call void @leaf_f64_dynamic_f64_dynamic__f32_daz_f32_daz_from__daz_daz()
; CHECK-NEXT:    call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz()
; CHECK-NEXT:    ret void
;
  call void @leaf_dynamic_dynamic_from_daz_daz()
  call void @leaf_dynamic_dynamic_from_daz_daz_and_ieee_ieee()
  call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz_and_ieee_ieee()
  call void @leaf_f64_dynamic_f64_dynamic__f32_daz_f32_daz_from__daz_daz()
  call void @leaf_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic__dynamic_dynamic_from_daz_daz()
  ret void
}

; positive-zero,positive-zero entry point
define void @func_dapz_dapz() #4 {
; CHECK-LABEL: define void @func_dapz_dapz
; CHECK-SAME: () #[[ATTR3]] {
; CHECK-NEXT:    call void @leaf_dynamic_dynamic_from_dapz_dapz()
; CHECK-NEXT:    ret void
;
  call void @leaf_dynamic_dynamic_from_dapz_dapz()
  ret void
}

; Could be fully preserve-sign,preserve-sign, but this isn't a
; realistic case and we don't bother trying to handle it.
define internal void @leaf_f64_dynamic_f64_dynamic__f32_daz_f32_daz_from__daz_daz() #5 {
; CHECK-LABEL: define internal void @leaf_f64_dynamic_f64_dynamic__f32_daz_f32_daz_from__daz_daz
; CHECK-SAME: () #[[ATTR4:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; -> ieee,ieee
define internal void @leaf_dynamic_ieee_from_ieee_ieee() #6 {
; CHECK-LABEL: define internal void @leaf_dynamic_ieee_from_ieee_ieee() {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; -> ieee,ieee
define internal void @leaf_ieee_dynamic_from_ieee_ieee() #7 {
; CHECK-LABEL: define internal void @leaf_ieee_dynamic_from_ieee_ieee() {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Specialize the f64 mode to ieee,ieee but leave f32 as dynamic,dynamic
define internal void @leaf_dynamic_dynamic_from_f64_ieee_f32_dynamic() #0 {
; CHECK-LABEL: define internal void @leaf_dynamic_dynamic_from_f64_ieee_f32_dynamic
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

define void @func_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic() #1 {
; CHECK-LABEL: define void @func_f64_ieee_f64_ieee__f32_dynamic_f32_dynamic
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    call void @leaf_dynamic_dynamic_from_f64_ieee_f32_dynamic()
; CHECK-NEXT:    ret void
;
  call void @leaf_dynamic_dynamic_from_f64_ieee_f32_dynamic()
  ret void
}

; -> preserve-sign,ieee.
define internal void @leaf_daz_dynamic_from_dynamic_ieee() #8 {
; CHECK-LABEL: define internal void @leaf_daz_dynamic_from_dynamic_ieee
; CHECK-SAME: () #[[ATTR5:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

define void @dynamic_ieee() #6 {
; CHECK-LABEL: define void @dynamic_ieee
; CHECK-SAME: () #[[ATTR6:[0-9]+]] {
; CHECK-NEXT:    call void @leaf_daz_dynamic_from_dynamic_ieee()
; CHECK-NEXT:    ret void
;
  call void @leaf_daz_dynamic_from_dynamic_ieee()
  ret void
}

; Leave unchanged as ieee,ieeee
define internal void @leaf_ieee_ieee_from_dynamic() {
; CHECK-LABEL: define internal void @leaf_ieee_ieee_from_dynamic() {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Leave unchanged as dynamic,dynamic
define internal void @leaf_dynamic_from_dynamic() {
; CHECK-LABEL: define internal void @leaf_dynamic_from_dynamic() {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

; Leave unchanged as preserve-sign,preserve-sign
define internal void @leaf_daz_daz_from_dynamic() #3 {
; CHECK-LABEL: define internal void @leaf_daz_daz_from_dynamic
; CHECK-SAME: () #[[ATTR0]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

define void @dynamic_dynamic() #0 {
; CHECK-LABEL: define void @dynamic_dynamic
; CHECK-SAME: () #[[ATTR2]] {
; CHECK-NEXT:    call void @leaf_ieee_ieee_from_dynamic()
; CHECK-NEXT:    call void @leaf_daz_daz_from_dynamic()
; CHECK-NEXT:    call void @leaf_dynamic_from_dynamic()
; CHECK-NEXT:    ret void
;
  call void @leaf_ieee_ieee_from_dynamic()
  call void @leaf_daz_daz_from_dynamic()
  call void @leaf_dynamic_from_dynamic()
  ret void
}

define internal void @leaf_ieee_f64_daz_f32() #9 {
; CHECK-LABEL: define internal void @leaf_ieee_f64_daz_f32
; CHECK-SAME: () #[[ATTR7:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

define internal void @leaf_ieee_f64_daz_f32_from_ieee_f64_dynamic_f32() #10 {
; CHECK-LABEL: define internal void @leaf_ieee_f64_daz_f32_from_ieee_f64_dynamic_f32
; CHECK-SAME: () #[[ATTR8:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

define void @ieee_f64_dynamic_f32() #1 {
; CHECK-LABEL: define void @ieee_f64_dynamic_f32
; CHECK-SAME: () #[[ATTR1]] {
; CHECK-NEXT:    call void @leaf_ieee_f64_daz_f32()
; CHECK-NEXT:    call void @leaf_ieee_f64_daz_f32_from_ieee_f64_dynamic_f32()
; CHECK-NEXT:    ret void
;
  call void @leaf_ieee_f64_daz_f32()
  call void @leaf_ieee_f64_daz_f32_from_ieee_f64_dynamic_f32()
  ret void
}

; => "preserve-sign,positive-zero" + "denormal-fp-math-f32"="ieee,positive-zero"
define internal void @leaf_daz_dynamic_dynamic_dapz_from_daz_dapz_ieee_dapz() #11 {
; CHECK-LABEL: define internal void @leaf_daz_dynamic_dynamic_dapz_from_daz_dapz_ieee_dapz
; CHECK-SAME: () #[[ATTR9:[0-9]+]] {
; CHECK-NEXT:    call void @call_of_mystery()
; CHECK-NEXT:    ret void
;
  call void @call_of_mystery()
  ret void
}

define void @daz_dapz_ieee_dapz() #12 {
; CHECK-LABEL: define void @daz_dapz_ieee_dapz
; CHECK-SAME: () #[[ATTR9]] {
; CHECK-NEXT:    call void @leaf_daz_dynamic_dynamic_dapz_from_daz_dapz_ieee_dapz()
; CHECK-NEXT:    ret void
;
  call void @leaf_daz_dynamic_dynamic_dapz_from_daz_dapz_ieee_dapz()
  ret void
}

attributes #0 = { "denormal-fp-math"="dynamic,dynamic" }
attributes #1 = { "denormal-fp-math-f32"="dynamic,dynamic" }
attributes #2 = { "denormal-fp-math"="ieee,ieee" }
attributes #3 = { "denormal-fp-math"="preserve-sign,preserve-sign" }
attributes #4 = { "denormal-fp-math"="positive-zero,positive-zero" }
attributes #5 = { "denormal-fp-math"="dynamic,dynamic" "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #6 = { "denormal-fp-math"="dynamic,ieee" }
attributes #7 = { "denormal-fp-math"="ieee,dynamic" }
attributes #8 = { "denormal-fp-math"="preserve-sign,dynamic" }
attributes #9 = { "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
attributes #10 = { "denormal-fp-math"="preserve-sign,preserve-sign" "denormal-fp-math-f32"="ieee,ieee" }
attributes #11 = { "denormal-fp-math"="preserve-sign,dynamic" "denormal-fp-math-f32"="dynamic,positive-zero" }
attributes #12 = { "denormal-fp-math"="preserve-sign,positive-zero" "denormal-fp-math-f32"="ieee,positive-zero" }
;.
; CHECK: attributes #[[ATTR0]] = { "denormal-fp-math"="preserve-sign,preserve-sign" }
; CHECK: attributes #[[ATTR1]] = { "denormal-fp-math-f32"="dynamic,dynamic" }
; CHECK: attributes #[[ATTR2]] = { "denormal-fp-math"="dynamic,dynamic" }
; CHECK: attributes #[[ATTR3]] = { "denormal-fp-math"="positive-zero,positive-zero" }
; CHECK: attributes #[[ATTR4]] = { "denormal-fp-math"="dynamic,dynamic" "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
; CHECK: attributes #[[ATTR5]] = { "denormal-fp-math"="preserve-sign,ieee" }
; CHECK: attributes #[[ATTR6]] = { "denormal-fp-math"="dynamic,ieee" }
; CHECK: attributes #[[ATTR7]] = { "denormal-fp-math-f32"="preserve-sign,preserve-sign" }
; CHECK: attributes #[[ATTR8]] = { "denormal-fp-math"="preserve-sign,preserve-sign" "denormal-fp-math-f32"="ieee,ieee" }
; CHECK: attributes #[[ATTR9]] = { "denormal-fp-math"="preserve-sign,positive-zero" "denormal-fp-math-f32"="ieee,positive-zero" }
;.
