; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt -passes=inline -enable-noalias-to-md-conversion -S < %s | FileCheck %s
; RUN: opt -passes=inline -enable-noalias-to-md-conversion --enable-knowledge-retention -S < %s | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define void @hello(ptr noalias nocapture %a, ptr noalias nocapture readonly %c) #0 {
; CHECK-LABEL: define {{[^@]+}}@hello
; CHECK-SAME: (ptr noalias captures(none) [[A:%.*]], ptr noalias readonly captures(none) [[C:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr [[C]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[A]], i64 5
; CHECK-NEXT:    store float [[TMP0]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %0 = load float, ptr %c, align 4
  %arrayidx = getelementptr inbounds float, ptr %a, i64 5
  store float %0, ptr %arrayidx, align 4
  ret void
}

define void @foo(ptr noalias nocapture %a, ptr noalias nocapture readonly %c) #0 {
; CHECK-LABEL: define {{[^@]+}}@foo
; CHECK-SAME: (ptr noalias captures(none) [[A:%.*]], ptr noalias readonly captures(none) [[C:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META0:![0-9]+]])
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
; CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr [[C]], align 4, !alias.scope [[META3]], !noalias [[META0]]
; CHECK-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds float, ptr [[A]], i64 5
; CHECK-NEXT:    store float [[TMP0]], ptr [[ARRAYIDX_I]], align 4, !alias.scope [[META0]], !noalias [[META3]]
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[C]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[A]], i64 7
; CHECK-NEXT:    store float [[TMP1]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret void
;
entry:
  tail call void @hello(ptr %a, ptr %c)
  %0 = load float, ptr %c, align 4
  %arrayidx = getelementptr inbounds float, ptr %a, i64 7
  store float %0, ptr %arrayidx, align 4
  ret void
}

define void @hello2(ptr noalias nocapture %a, ptr noalias nocapture %b, ptr nocapture readonly %c) #0 {
; CHECK-LABEL: define {{[^@]+}}@hello2
; CHECK-SAME: (ptr noalias captures(none) [[A:%.*]], ptr noalias captures(none) [[B:%.*]], ptr readonly captures(none) [[C:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr [[C]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[A]], i64 6
; CHECK-NEXT:    store float [[TMP0]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds float, ptr [[B]], i64 8
; CHECK-NEXT:    store float [[TMP0]], ptr [[ARRAYIDX1]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %0 = load float, ptr %c, align 4
  %arrayidx = getelementptr inbounds float, ptr %a, i64 6
  store float %0, ptr %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds float, ptr %b, i64 8
  store float %0, ptr %arrayidx1, align 4
  ret void
}

; Check that when hello() is inlined into foo(), and then foo() is inlined into
; foo2(), the noalias scopes are properly concatenated.
define void @foo2(ptr nocapture %a, ptr nocapture %b, ptr nocapture readonly %c) #0 {
; CHECK-LABEL: define {{[^@]+}}@foo2
; CHECK-SAME: (ptr captures(none) [[A:%.*]], ptr captures(none) [[B:%.*]], ptr readonly captures(none) [[C:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META5:![0-9]+]])
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META8:![0-9]+]])
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META10:![0-9]+]])
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META13:![0-9]+]])
; CHECK-NEXT:    [[TMP0:%.*]] = load float, ptr [[C]], align 4, !alias.scope [[META15:![0-9]+]], !noalias [[META16:![0-9]+]]
; CHECK-NEXT:    [[ARRAYIDX_I_I:%.*]] = getelementptr inbounds float, ptr [[A]], i64 5
; CHECK-NEXT:    store float [[TMP0]], ptr [[ARRAYIDX_I_I]], align 4, !alias.scope [[META16]], !noalias [[META15]]
; CHECK-NEXT:    [[TMP1:%.*]] = load float, ptr [[C]], align 4, !alias.scope [[META8]], !noalias [[META5]]
; CHECK-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds float, ptr [[A]], i64 7
; CHECK-NEXT:    store float [[TMP1]], ptr [[ARRAYIDX_I]], align 4, !alias.scope [[META5]], !noalias [[META8]]
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META17:![0-9]+]])
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META20:![0-9]+]])
; CHECK-NEXT:    [[TMP2:%.*]] = load float, ptr [[C]], align 4, !noalias [[META22:![0-9]+]]
; CHECK-NEXT:    [[ARRAYIDX_I1:%.*]] = getelementptr inbounds float, ptr [[A]], i64 6
; CHECK-NEXT:    store float [[TMP2]], ptr [[ARRAYIDX_I1]], align 4, !alias.scope [[META17]], !noalias [[META20]]
; CHECK-NEXT:    [[ARRAYIDX1_I:%.*]] = getelementptr inbounds float, ptr [[B]], i64 8
; CHECK-NEXT:    store float [[TMP2]], ptr [[ARRAYIDX1_I]], align 4, !alias.scope [[META20]], !noalias [[META17]]
; CHECK-NEXT:    [[TMP3:%.*]] = load float, ptr [[C]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[A]], i64 7
; CHECK-NEXT:    store float [[TMP3]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret void
;
entry:
  tail call void @foo(ptr %a, ptr %c)
  tail call void @hello2(ptr %a, ptr %b, ptr %c)
  %0 = load float, ptr %c, align 4
  %arrayidx = getelementptr inbounds float, ptr %a, i64 7
  store float %0, ptr %arrayidx, align 4
  ret void
}

; CHECK: !0 = !{!1}
; CHECK: !1 = distinct !{!1, !2, !"hello: %a"}
; CHECK: !2 = distinct !{!2, !"hello"}
; CHECK: !3 = !{!4}
; CHECK: !4 = distinct !{!4, !2, !"hello: %c"}
; CHECK: !5 = !{!6}
; CHECK: !6 = distinct !{!6, !7, !"foo: %a"}
; CHECK: !7 = distinct !{!7, !"foo"}
; CHECK: !8 = !{!9}
; CHECK: !9 = distinct !{!9, !7, !"foo: %c"}
; CHECK: !10 = !{!11}
; CHECK: !11 = distinct !{!11, !12, !"hello: %a"}
; CHECK: !12 = distinct !{!12, !"hello"}
; CHECK: !13 = !{!14}
; CHECK: !14 = distinct !{!14, !12, !"hello: %c"}
; CHECK: !15 = !{!14, !9}
; CHECK: !16 = !{!11, !6}
; CHECK: !17 = !{!18}
; CHECK: !18 = distinct !{!18, !19, !"hello2: %a"}
; CHECK: !19 = distinct !{!19, !"hello2"}
; CHECK: !20 = !{!21}
; CHECK: !21 = distinct !{!21, !19, !"hello2: %b"}
; CHECK: !22 = !{!18, !21}

attributes #0 = { nounwind uwtable }

