# Check that "assembled_snippet" is fetched correctly from object file.
# Feel free to update the snippet in this test if the code generated by the
# snippet repetitor was changed intentionally and it is still fetched correctly.

# RUN: llvm-exegesis --mtriple=x86_64-linux-gnu --mcpu=x86-64 --benchmark-phase=prepare-and-assemble-snippet \
# RUN:               --snippets-file=%s --mode=latency --repetition-mode=duplicate \
# RUN: | FileCheck %s --check-prefix=CHECK-LINUX

# RUN: llvm-exegesis --mtriple=x86_64-windows-gnu --mcpu=x86-64 --benchmark-phase=prepare-and-assemble-snippet \
# RUN:               --snippets-file=%s --mode=latency --repetition-mode=duplicate \
# RUN: | FileCheck %s --check-prefix=CHECK-WINDOWS-GNU

# RUN: llvm-exegesis --mtriple=x86_64-windows-msvc --mcpu=x86-64 --benchmark-phase=prepare-and-assemble-snippet \
# RUN:               --snippets-file=%s --mode=latency --repetition-mode=duplicate \
# RUN: | FileCheck %s --check-prefix=CHECK-WINDOWS-MSVC

# LLVM-EXEGESIS-DEFREG RDI 0
# LLVM-EXEGESIS-DEFREG RSI 0
# LLVM-EXEGESIS-DEFREG RAX 0
leaq    (%rdi,%rsi), %rax

# CHECK-LINUX: cpu_name:          x86-64
# CHECK-LINUX: llvm_triple:       x86_64-unknown-linux-gnu
# CHECK-LINUX: assembled_snippet: 48BF000000000000000048BE000000000000000048B80000000000000000488D0437488D0437488D0437488D0437C3{{$}}

# CHECK-WINDOWS-GNU: cpu_name:          x86-64
# CHECK-WINDOWS-GNU: llvm_triple:       x86_64-unknown-windows-gnu
# CHECK-WINDOWS-GNU: assembled_snippet: 565748BF000000000000000048BE000000000000000048B80000000000000000488D0437488D0437488D0437488D04375F5EC3{{$}}

# CHECK-WINDOWS-MSVC: cpu_name:          x86-64
# CHECK-WINDOWS-MSVC: llvm_triple:       x86_64-unknown-windows-msvc
# CHECK-WINDOWS-MSVC: assembled_snippet: 565748BF000000000000000048BE000000000000000048B80000000000000000488D0437488D0437488D0437488D04375F5EC3{{$}}
