; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple aarch64-none-linux-gnu -mattr=+fullfp16 < %s | FileCheck %s

define <8 x half> @sel.v8f16.fmul(ptr %p, ptr %q, <8 x half> %a, <8 x half> %b, <4 x half> %c) {
; CHECK-LABEL: sel.v8f16.fmul:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul v1.8h, v1.8h, v0.h[0]
; CHECK-NEXT:    fmul v2.4h, v2.4h, v0.h[0]
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    str d2, [x0]
; CHECK-NEXT:    ret
  %splat = shufflevector <8 x half> %a, <8 x half> poison, <8 x i32> zeroinitializer
  %splat2 = shufflevector <8 x half> %a, <8 x half> poison, <4 x i32> zeroinitializer

  %r = fmul <8 x half> %b, %splat
  %r2 = fmul <4 x half> %c, %splat2
  store <4 x half> %r2, ptr %p
  ret <8 x half> %r
}

define <4 x float> @sel.v4f32.fmul(ptr %p, ptr %q, <4 x float> %a, <4 x float> %b, <2 x float> %c) {
; CHECK-LABEL: sel.v4f32.fmul:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul v1.4s, v1.4s, v0.s[0]
; CHECK-NEXT:    fmul v2.2s, v2.2s, v0.s[0]
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    str d2, [x0]
; CHECK-NEXT:    ret
  %splat = shufflevector <4 x float> %a, <4 x float> poison, <4 x i32> zeroinitializer
  %splat2 = shufflevector <4 x float> %a, <4 x float> poison, <2 x i32> zeroinitializer

  %r = fmul <4 x float> %b, %splat
  %r2 = fmul <2 x float> %c, %splat2
  store <2 x float> %r2, ptr %p
  ret <4 x float> %r
}

define <8 x i16> @sel.v8i16.mul(ptr %p, ptr %q, <8 x i16> %a, <8 x i16> %b, <4 x i16> %c) {
; CHECK-LABEL: sel.v8i16.mul:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul v1.8h, v1.8h, v0.h[0]
; CHECK-NEXT:    mul v2.4h, v2.4h, v0.h[0]
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    str d2, [x0]
; CHECK-NEXT:    ret
  %splat = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> zeroinitializer
  %splat2 = shufflevector <8 x i16> %a, <8 x i16> poison, <4 x i32> zeroinitializer

  %r = mul <8 x i16> %b, %splat
  %r2 = mul <4 x i16> %c, %splat2
  store <4 x i16> %r2, ptr %p
  ret <8 x i16> %r
}

define <4 x i32> @sel.v4i32.mul(ptr %p, ptr %q, <4 x i32> %a, <4 x i32> %b, <2 x i32> %c) {
; CHECK-LABEL: sel.v4i32.mul:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mul v1.4s, v1.4s, v0.s[0]
; CHECK-NEXT:    mul v2.2s, v2.2s, v0.s[0]
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    str d2, [x0]
; CHECK-NEXT:    ret
  %splat = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> zeroinitializer
  %splat2 = shufflevector <4 x i32> %a, <4 x i32> poison, <2 x i32> zeroinitializer

  %r = mul <4 x i32> %b, %splat
  %r2 = mul <2 x i32> %c, %splat2
  store <2 x i32> %r2, ptr %p
  ret <4 x i32> %r
}

define <4 x i64> @sel.v4i32.smull(<4 x i32> %a, <4 x i32> %b, <2 x i32> %c) {
; CHECK-LABEL: sel.v4i32.smull:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smull2 v2.2d, v1.4s, v0.s[0]
; CHECK-NEXT:    smull v0.2d, v1.2s, v0.s[0]
; CHECK-NEXT:    mov v1.16b, v2.16b
; CHECK-NEXT:    ret
  %ext = sext <4 x i32> %a to <4 x i64>
  %splat = shufflevector <4 x i64> %ext, <4 x i64> poison, <4 x i32> zeroinitializer
  %d = sext <4 x i32> %b to <4 x i64>
  %r = mul <4 x i64> %d, %splat
  ret <4 x i64> %r
}

define <4 x i64> @sel.v4i32.umull(<4 x i32> %a, <4 x i32> %b, <2 x i32> %c) {
; CHECK-LABEL: sel.v4i32.umull:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umull2 v2.2d, v1.4s, v0.s[0]
; CHECK-NEXT:    umull v0.2d, v1.2s, v0.s[0]
; CHECK-NEXT:    mov v1.16b, v2.16b
; CHECK-NEXT:    ret
  %ext = zext <4 x i32> %a to <4 x i64>
  %splat = shufflevector <4 x i64> %ext, <4 x i64> poison, <4 x i32> zeroinitializer
  %d = zext <4 x i32> %b to <4 x i64>
  %r = mul <4 x i64> %d, %splat
  ret <4 x i64> %r
}

define <4 x i32> @sel.v4i32.sqdmull(<8 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: sel.v4i32.sqdmull:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    sqdmull v2.4s, v0.4h, v1.h[0]
; CHECK-NEXT:    sqdmlal2 v2.4s, v0.8h, v1.h[0]
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
entry:
  %c = shufflevector <8 x i16> %a, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %d = shufflevector <4 x i16> %b, <4 x i16> poison, <4 x i32> zeroinitializer
  %e = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %c, <4 x i16> %d)
  %f = shufflevector <8 x i16> %a, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %g = tail call <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16> %f, <4 x i16> %d)
  %h = tail call <4 x i32> @llvm.aarch64.neon.sqadd.v4i32(<4 x i32> %e, <4 x i32> %g)
  ret <4 x i32> %h
}

declare <4 x i32> @llvm.aarch64.neon.sqdmull.v4i32(<4 x i16>, <4 x i16>)
declare <4 x i32> @llvm.aarch64.neon.sqadd.v4i32(<4 x i32>, <4 x i32>)
