; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i1 @vec_reduce_umax_non_zero(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umax_non_zero(
; CHECK-NEXT:    [[X:%.*]] = add nuw <4 x i8> [[XX:%.*]], <i8 0, i8 1, i8 0, i8 0>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = add nuw <4 x i8> %xx, <i8 0, i8 1, i8 0, i8 0>
  %v = call i8 @llvm.vector.reduce.umax(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_umax_non_zero_fail(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umax_non_zero_fail(
; CHECK-NEXT:    [[X:%.*]] = add nsw <4 x i8> [[XX:%.*]], splat (i8 1)
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = add nsw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.umax(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_umin_non_zero(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umin_non_zero(
; CHECK-NEXT:    ret i1 false
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.umin(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_umin_non_zero_fail(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umin_non_zero_fail(
; CHECK-NEXT:    [[X:%.*]] = add nuw <4 x i8> [[XX:%.*]], <i8 0, i8 1, i8 1, i8 1>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umin.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = add nuw <4 x i8> %xx, <i8 0, i8 1, i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.umin(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_smax_non_zero0(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smax_non_zero0(
; CHECK-NEXT:    ret i1 false
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.smax(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_smax_non_zero1(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smax_non_zero1(
; CHECK-NEXT:    [[X0:%.*]] = and <4 x i8> [[XX:%.*]], <i8 127, i8 -1, i8 -1, i8 -1>
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[X0]], <i8 1, i8 0, i8 0, i8 0>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x0 = and <4 x i8> %xx, <i8 127, i8 255, i8 255, i8 255>
  %x = or <4 x i8> %x0, <i8 1, i8 0, i8 0, i8 0>
  %v = call i8 @llvm.vector.reduce.smax(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_smax_non_zero_fail(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smax_non_zero_fail(
; CHECK-NEXT:    [[X0:%.*]] = and <4 x i8> [[XX:%.*]], <i8 127, i8 -1, i8 -1, i8 -1>
; CHECK-NEXT:    [[X:%.*]] = add nuw <4 x i8> [[X0]], <i8 1, i8 0, i8 0, i8 0>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x0 = and <4 x i8> %xx, <i8 127, i8 255, i8 255, i8 255>
  %x = add nuw <4 x i8> %x0, <i8 1, i8 0, i8 0, i8 0>
  %v = call i8 @llvm.vector.reduce.smax(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_smin_non_zero0(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smin_non_zero0(
; CHECK-NEXT:    ret i1 false
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.smin(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_smin_non_zero1(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smin_non_zero1(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 0, i8 0, i8 0, i8 -128>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.smin.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = or <4 x i8> %xx, <i8 0, i8 0, i8 0, i8 128>
  %v = call i8 @llvm.vector.reduce.smin(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @vec_reduce_smin_non_zero_fail(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smin_non_zero_fail(
; CHECK-NEXT:    [[X0:%.*]] = or <4 x i8> [[XX:%.*]], <i8 0, i8 0, i8 0, i8 -128>
; CHECK-NEXT:    [[X:%.*]] = add <4 x i8> [[X0]], <i8 0, i8 0, i8 0, i8 1>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.smin.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x0 = or <4 x i8> %xx, <i8 0, i8 0, i8 0, i8 128>
  %x = add <4 x i8> %x0, <i8 0, i8 0, i8 0, i8 1>
  %v = call i8 @llvm.vector.reduce.smin(<4 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i8 @vec_reduce_umax_known0(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umax_known0(
; CHECK-NEXT:    ret i8 1
;
  %x = or <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.umax(<4 x i8> %x)
  %r = and i8 %v, 1
  ret i8 %r
}

define i8 @vec_reduce_umax_known1(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umax_known1(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 1, i8 1, i8 1, i8 -128>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], -128
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 128>
  %v = call i8 @llvm.vector.reduce.umax(<4 x i8> %x)
  %r = and i8 %v, 128
  ret i8 %r
}

define i8 @vec_reduce_umax_known_fail0(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umax_known_fail0(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 1, i8 1, i8 1, i8 -128>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 1
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 128>
  %v = call i8 @llvm.vector.reduce.umax(<4 x i8> %x)
  %r = and i8 %v, 1
  ret i8 %r
}

define i8 @vec_reduce_umax_known_fail1(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umax_known_fail1(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 1, i8 2, i8 4, i8 8>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 1
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or <4 x i8> %xx, <i8 1, i8 2, i8 4, i8 8>
  %v = call i8 @llvm.vector.reduce.umax(<4 x i8> %x)
  %r = and i8 %v, 1
  ret i8 %r
}

define i8 @vec_reduce_umin_known0(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umin_known0(
; CHECK-NEXT:    ret i8 1
;
  %x = or <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.umin(<4 x i8> %x)
  %r = and i8 %v, 1
  ret i8 %r
}

define i8 @vec_reduce_umin_known1(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umin_known1(
; CHECK-NEXT:    [[X:%.*]] = and <4 x i8> [[XX:%.*]], <i8 127, i8 -1, i8 -1, i8 -1>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umin.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], -128
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = and <4 x i8> %xx, <i8 127, i8 255, i8 255, i8 255>
  %v = call i8 @llvm.vector.reduce.umin(<4 x i8> %x)
  %r = and i8 %v, 128
  ret i8 %r
}

define i8 @vec_reduce_umin_known_fail0(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umin_known_fail0(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 1, i8 0, i8 0, i8 0>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umin.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 1
; CHECK-NEXT:    ret i8 [[R]]
;
  %x0 = and <4 x i8> %xx, <i8 127, i8 255, i8 255, i8 255>
  %x = or <4 x i8> %xx, <i8 1, i8 0, i8 0, i8 0>
  %v = call i8 @llvm.vector.reduce.umin(<4 x i8> %x)
  %r = and i8 %v, 1
  ret i8 %r
}

define i8 @vec_reduce_umin_known_fail1(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_umin_known_fail1(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 1, i8 2, i8 4, i8 8>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umin.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 1
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or <4 x i8> %xx, <i8 1, i8 2, i8 4, i8 8>
  %v = call i8 @llvm.vector.reduce.umin(<4 x i8> %x)
  %r = and i8 %v, 1
  ret i8 %r
}

define i8 @vec_reduce_smax_known(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smax_known(
; CHECK-NEXT:    ret i8 4
;
  %x = or <4 x i8> %xx, <i8 4, i8 4, i8 4, i8 5>
  %v = call i8 @llvm.vector.reduce.smax(<4 x i8> %x)
  %r = and i8 %v, 4
  ret i8 %r
}

define i8 @vec_reduce_smax_known_fail(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smax_known_fail(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 4, i8 4, i8 8, i8 5>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 4
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or <4 x i8> %xx, <i8 4, i8 4, i8 8, i8 5>
  %v = call i8 @llvm.vector.reduce.umax(<4 x i8> %x)
  %r = and i8 %v, 4
  ret i8 %r
}

define i8 @vec_reduce_smin_known(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smin_known(
; CHECK-NEXT:    ret i8 8
;
  %x = or <4 x i8> %xx, <i8 8, i8 24, i8 56, i8 9>
  %v = call i8 @llvm.vector.reduce.smin(<4 x i8> %x)
  %r = and i8 %v, 8
  ret i8 %r
}

define i8 @vec_reduce_smin_known_fail(<4 x i8> %xx) {
; CHECK-LABEL: @vec_reduce_smin_known_fail(
; CHECK-NEXT:    [[X:%.*]] = or <4 x i8> [[XX:%.*]], <i8 8, i8 23, i8 56, i8 9>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.smin.v4i8(<4 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = and i8 [[V]], 8
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or <4 x i8> %xx, <i8 8, i8 23, i8 56, i8 9>
  %v = call i8 @llvm.vector.reduce.smin(<4 x i8> %x)
  %r = and i8 %v, 8
  ret i8 %r
}
