/* GNU moe - My Own Editor
   Copyright (C) 2005-2026 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Menu {

// Return handle index, or -1 if aborted.
//
int bufhandle_menu( int current, const int abort_key );

/* 'name' contains the file name to be modified (may be empty).
   Return false if aborted.
*/
bool file_menu( const std::string & prompt, std::string & name );

/* 'name' contains the default result (may be empty), and stores the result
   (if any).
   Return the size of the result string, 0 if none, -1 if aborted.
   Clear 'name' if aborted.
*/
int get_filename( const std::string & prompt, std::string & name,
                  const int abort_key = 3 );

bool is_regular( const std::string & name, bool * can_statp = 0,
                 bool * can_readp = 0 );

bool make_dirs( const std::string & name );

const std::string & my_basename( const std::string & name );

bool tilde_expansion( std::string & name );

bool validate_filename( std::string & name );


void help_menu( const int abort_key1, const int abort_key2 );


void options_menu( Buffer & buffer, const int abort_key );

} // end namespace Menu
