/*
 This file is part of GNU Taler
 (C) 2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

// qtart "std" library
// @ts-ignore
import * as std from "std";

export function processExit(status: number): never {
  std.exit(status);
  throw Error("not reached");
}

export function processArgv(): string[] {
  // @ts-ignore
  return ["qtart", ...globalThis.scriptArgs];
}

export function readlinePrompt(prompt: string): Promise<string> {
  throw new Error("realinePrompt not yet supported in qtart");
}

export function pathBasename(p: string): string {
  const slashIndex = p.lastIndexOf("/");
  if (slashIndex < 0) {
    return p;
  }
  return p.substring(0, slashIndex);
}

export function pathHomedir(): string {
  return std.getenv("HOME");
}

export function setUnhandledRejectionHandler(h: (e: any) => void): void {
  // not supported
}

export function getenv(name: string): string | undefined {
  return std.getenv(name);
}

export function readFile(fileName: string): string {
  throw new Error("readFile not yet supported in qtart");
}
