---
title: Install Canoeboot on Lenovo ThinkPad T440p
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](ivy_has_common.md).**

Open source BIOS/UEFI firmware
-------------------------

This document will teach you how to install Canoeboot, on your
Lenovo ThinkPad T440p laptop motherboard.
Canoeboot is a [Free Software](https://writefreesoftware.org/learn) project
that replaces proprietary BIOS/UEFI firmware.

### Preparing a release Rom

### 4MB CBFS

CBFS is 4MB on this board, so when external flashing, you can just break off
the upper 4MB part of the image and flash that. Keep this in mind if you're
flashing externally.

When externally flashing the lower 8MB part, you can optionally flash the
IFD and GbE regions if that is appropriate for your setup.

### Splitting The Rom

You can use `dd` to easily split your rom into the two separate portions for
external flashing.

	dd if=canoeboot.rom of=top.rom bs=1M skip=8
	dd if=canoeboot.rom of=bottom.rom bs=1M count=8

Flash the top chip with top.rom, and tho bottom chip with bottom.rom.
Don't worry about knowing which chip is which on a standard setup; flashprog will let you know if the 
image size is incorrect for the chip you're flashing.

### Disassembly

Start by removing the back cover screws and the main battery.\
<img tabindex=1 src="https://av.canoeboot.org/board/t440p/t440p_back.jpg" /><span class="f"><img src="https://av.canoeboot.org/board/t440p/t440p_back_orig.jpg" /></span>

You can then remove the back cover by sliding it off.
Next you need to:

+ Unplug the cmos battery
+ Unplug and unroute the fan cable
+ Unplug and unroute the black LED cable
+ Remove all visible screws

*Note: the ultrabay screw will loosen, but not come out of the assembly*\
<img tabindex=1 src="https://av.canoeboot.org/board/t440p/t440p_nocover.jpg" /><span class="f"><img src="https://av.canoeboot.org/board/t440p/t440p_nocover_orig.jpg" /></span>

Now you can pull up around the sides of the bottom assembly to release it.
Pull it upwards and lift it open to the front of the machine like a clamshell.
Make sure not to break the wires connecting the assembly to the rest of the machine.\
<img tabindex=1 src="https://av.canoeboot.org/board/t440p/t440p_open.jpg" /><span class="f"><img src="https://av.canoeboot.org/board/t440p/t440p_open_orig.jpg" /></span>

You should now be able to see the two flash chips near the RAM.\
<img tabindex=1 src="https://av.canoeboot.org/board/t440p/t440p_chipLocation.jpg" /><span class="f"><img src="https://av.canoeboot.org/board/t440p/t440p_chipLocation_orig.jpg" /></span>

You can now proceed to [flashing](/docs/install/spi.html) this machine.

Errata
------

### thinkpad\_acpi issues {#thinkpad-acpi}

It has been reported by that `thinkpad_acpi` does not load correctly on the T440p.

If you encounter this, check [this page](../../faq.md#thinkpad-acpi)
for details as to how to fix this.
