/*
 * This file is part of the coreboot project.
 *
 * Copyright 2014 Google Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __MAINBOARD_GOOGLE_RUSH_RYU_PMIC_H__
#define __MAINBOARD_GOOGLE_RUSH_RYU_PMIC_H__

#include <stdint.h>

/* A44/Ryu has a TI 65913 PMIC on bus 4 (PWR_I2C) */
enum {
	TI65913_I2C_ADDR_PAGE1 = 0x58,
	TI65913_I2C_ADDR_PAGE2 = 0x59
};

enum {
	/* Registers in PAGE1 */
	TI65913_SMPS12_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x20,
	TI65913_SMPS12_TSTEP,
	TI65913_SMPS12_FORCE,
	TI65913_SMPS12_VOLTAGE,

	TI65913_SMPS3_CTRL,
	TI65913_SMPS3_VOLTAGE = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x27,

	TI65913_SMPS45_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x28,
	TI65913_SMPS45_TSTEP,
	TI65913_SMPS45_FORCE,
	TI65913_SMPS45_VOLTAGE,

	TI65913_SMPS6_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x2C,
	TI65913_SMPS6_TSTEP,
	TI65913_SMPS6_FORCE,
	TI65913_SMPS6_VOLTAGE,

	TI65913_SMPS7_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x30,
	TI65913_SMPS7_VOLTAGE = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x33,

	TI65913_SMPS8_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x34,
	TI65913_SMPS8_TSTEP,
	TI65913_SMPS8_FORCE,
	TI65913_SMPS8_VOLTAGE,

	TI65913_SMPS9_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x38,
	TI65913_SMPS9_VOLTAGE = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x3B,

	TI65913_SMPS10_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x3C,
	TI65913_SMPS10_STATUS = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x3F,

	TI65913_LDO1_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x50,
	TI65913_LDO1_VOLTAGE,
	TI65913_LDO2_CTRL,
	TI65913_LDO2_VOLTAGE,
	TI65913_LDO3_CTRL,
	TI65913_LDO3_VOLTAGE,
	TI65913_LDO4_CTRL,
	TI65913_LDO4_VOLTAGE,
	TI65913_LDO5_CTRL,
	TI65913_LDO5_VOLTAGE,
	TI65913_LDO6_CTRL,
	TI65913_LDO6_VOLTAGE,
	TI65913_LDO7_CTRL,
	TI65913_LDO7_VOLTAGE,
	TI65913_LDO8_CTRL,
	TI65913_LDO8_VOLTAGE,
	TI65913_LDO9_CTRL,
	TI65913_LDO9_VOLTAGE,

	TI65913_LDOLN_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x62,
	TI65913_LDOLN_VOLTAGE,
	TI65913_LDOUSB_CTRL,
	TI65913_LDOUSB_VOLTAGE,

	TI65913_LDO_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x6A,
	TI65913_LDO_PD_CTRL1,
	TI65913_LDO_PD_CTRL2,

	TI65913_LDO_SHORT_STATUS1 = (TI65913_I2C_ADDR_PAGE1 << 8) | 0x6D,
	TI65913_LDO_SHORT_STATUS2,

	TI65913_CLK32KGAUDIO_CTRL = (TI65913_I2C_ADDR_PAGE1 << 8) | 0xD5,

	TI65913_PAD2 = (TI65913_I2C_ADDR_PAGE1 << 8) | 0xFB,

	/* Registers in PAGE2 */
	TI65913_GPIO_DATA_IN  = (TI65913_I2C_ADDR_PAGE2 << 8) | 0x80,
	TI65913_GPIO_DATA_DIR,
	TI65913_GPIO_DATA_OUT,
};

/* Voltage selection */
enum {
	VSEL_1200 = 0x07,
};

/*
 * TI65913_LDO5_CTRL
 * TI65913_CLK32KGAUDIO_CTRL
 */
#define TI65913_MODE_ACTIVE_ON	(1 << 0)

/*
 * select PRIMARY or SECONDARY function on PAD2
 */
#define PAD2_GPIO_6_PRIMARY(data)		\
		((data) & ~(1 << 3))			/* clear bit 3 */
#define PAD2_GPIO_5_SEC_CLK32KGAUDIO(data)	\
		(((data) & ~(0x03 << 1)) | (0x01 << 1))	/* bit 2:1 = 01 */

/* TI65913_GPIO_DATA_DIR */
#define	TI65913_GPIO_6_OUTPUT	(1 << 6)

/* TI65913_GPIO_DATA_OUT */
#define	TI65913_GPIO_6_HIGH	(1 << 6)

int pmic_read_reg(unsigned bus, uint16_t reg, uint8_t *data);
void pmic_write_reg(unsigned bus, uint16_t reg, uint8_t val, int delay);
void pmic_init(unsigned bus);

#endif /* __MAINBOARD_GOOGLE_RUSH_RYU_PMIC_H__ */
