import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CopyDistributionResultFilterSensitiveLog, } from "../models/models_0";
import { de_CopyDistributionCommand, se_CopyDistributionCommand } from "../protocols/Aws_restXml";
export { $Command };
export class CopyDistributionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "CopyDistribution", {})
    .n("CloudFrontClient", "CopyDistributionCommand")
    .f(void 0, CopyDistributionResultFilterSensitiveLog)
    .ser(se_CopyDistributionCommand)
    .de(de_CopyDistributionCommand)
    .build() {
}
