﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agentcore-control/BedrockAgentCoreControlRequest.h>
#include <aws/bedrock-agentcore-control/BedrockAgentCoreControl_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace BedrockAgentCoreControl {
namespace Model {

/**
 */
class GetAgentRuntimeRequest : public BedrockAgentCoreControlRequest {
 public:
  AWS_BEDROCKAGENTCORECONTROL_API GetAgentRuntimeRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetAgentRuntime"; }

  AWS_BEDROCKAGENTCORECONTROL_API Aws::String SerializePayload() const override;

  AWS_BEDROCKAGENTCORECONTROL_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The unique identifier of the AgentCore Runtime to retrieve.</p>
   */
  inline const Aws::String& GetAgentRuntimeId() const { return m_agentRuntimeId; }
  inline bool AgentRuntimeIdHasBeenSet() const { return m_agentRuntimeIdHasBeenSet; }
  template <typename AgentRuntimeIdT = Aws::String>
  void SetAgentRuntimeId(AgentRuntimeIdT&& value) {
    m_agentRuntimeIdHasBeenSet = true;
    m_agentRuntimeId = std::forward<AgentRuntimeIdT>(value);
  }
  template <typename AgentRuntimeIdT = Aws::String>
  GetAgentRuntimeRequest& WithAgentRuntimeId(AgentRuntimeIdT&& value) {
    SetAgentRuntimeId(std::forward<AgentRuntimeIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the AgentCore Runtime to retrieve.</p>
   */
  inline const Aws::String& GetAgentRuntimeVersion() const { return m_agentRuntimeVersion; }
  inline bool AgentRuntimeVersionHasBeenSet() const { return m_agentRuntimeVersionHasBeenSet; }
  template <typename AgentRuntimeVersionT = Aws::String>
  void SetAgentRuntimeVersion(AgentRuntimeVersionT&& value) {
    m_agentRuntimeVersionHasBeenSet = true;
    m_agentRuntimeVersion = std::forward<AgentRuntimeVersionT>(value);
  }
  template <typename AgentRuntimeVersionT = Aws::String>
  GetAgentRuntimeRequest& WithAgentRuntimeVersion(AgentRuntimeVersionT&& value) {
    SetAgentRuntimeVersion(std::forward<AgentRuntimeVersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_agentRuntimeId;

  Aws::String m_agentRuntimeVersion;
  bool m_agentRuntimeIdHasBeenSet = false;
  bool m_agentRuntimeVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentCoreControl
}  // namespace Aws
