/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetMetaDataImpl;
import org.jkiss.utils.CommonUtils;

public class JDBCTableMetaData
implements DBCEntityMetaData {
    private final JDBCResultSetMetaDataImpl resultSetMetaData;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final List<JDBCColumnMetaData> columns = new ArrayList<JDBCColumnMetaData>();

    JDBCTableMetaData(@NotNull JDBCResultSetMetaDataImpl resultSetMetaData, String catalogName, String schemaName, @NotNull String tableName) {
        this.resultSetMetaData = resultSetMetaData;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public JDBCResultSetMetaDataImpl getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @NotNull
    public String getEntityName() {
        return this.tableName;
    }

    @NotNull
    public List<JDBCColumnMetaData> getAttributes() {
        return this.columns;
    }

    void addAttribute(JDBCColumnMetaData columnMetaData) {
        this.columns.add(columnMetaData);
    }

    public String toString() {
        return DBUtils.getSimpleQualifiedName((Object[])new Object[]{this.catalogName, this.schemaName, this.tableName});
    }

    public int hashCode() {
        return (this.catalogName == null ? 1 : this.catalogName.hashCode()) * (this.schemaName == null ? 2 : this.schemaName.hashCode()) * this.tableName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JDBCTableMetaData)) {
            return false;
        }
        JDBCTableMetaData md2 = (JDBCTableMetaData)obj;
        return CommonUtils.equalObjects((Object)this.catalogName, (Object)md2.catalogName) && CommonUtils.equalObjects((Object)this.schemaName, (Object)md2.schemaName) && CommonUtils.equalObjects((Object)this.tableName, (Object)md2.tableName);
    }
}

