/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.CreateProcedurePage;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedureConfigurator
implements DBEObjectConfigurator<PostgreProcedure> {
    protected static final Log log = Log.getLog(PostgreProcedureConfigurator.class);

    public PostgreProcedure configureObject(final @NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object parent, final @NotNull PostgreProcedure newProcedure, @NotNull Map<String, Object> options) {
        return (PostgreProcedure)new UITask<PostgreProcedure>(this){

            protected PostgreProcedure runTask() {
                CreateFunctionPage editPage = new CreateFunctionPage(monitor, newProcedure);
                if (!editPage.edit()) {
                    return null;
                }
                if (editPage.getProcedureType() == DBSProcedureType.FUNCTION) {
                    newProcedure.setKind(PostgreProcedureKind.f);
                    newProcedure.setReturnType(editPage.getReturnType());
                } else {
                    newProcedure.setKind(PostgreProcedureKind.p);
                }
                newProcedure.setName(editPage.getProcedureName());
                PostgreLanguage language = editPage.getLanguage();
                if (language != null) {
                    newProcedure.setLanguage(language);
                }
                newProcedure.setObjectDefinitionText("CREATE OR REPLACE " + String.valueOf(editPage.getProcedureType()) + " " + newProcedure.getFullQualifiedSignature() + (String)(newProcedure.getReturnType() == null ? "" : "\n\tRETURNS " + newProcedure.getReturnType().getFullyQualifiedName(DBPEvaluationContext.DDL)) + (String)(language == null ? "" : "\n\tLANGUAGE " + language.getName()) + "\nAS $" + editPage.getProcedureType().name().toLowerCase() + "$\n\tBEGIN\n\n\tEND;\n$" + editPage.getProcedureType().name().toLowerCase() + "$\n");
                return newProcedure;
            }
        }.execute();
    }

    private static class CreateFunctionPage
    extends CreateProcedurePage {
        private final PostgreProcedure parent;
        private final DBRProgressMonitor monitor;
        private PostgreLanguage language;
        private PostgreDataType returnType;
        private Combo returnTypeCombo;

        public CreateFunctionPage(DBRProgressMonitor monitor, PostgreProcedure parent) {
            super((DBSProcedure)parent);
            this.parent = parent;
            this.monitor = monitor;
        }

        public DBSProcedureType getPredefinedProcedureType() {
            if (((PostgreDataSource)this.parent.getDataSource()).isServerVersionAtLeast(11, 0)) {
                return null;
            }
            return DBSProcedureType.FUNCTION;
        }

        public DBSProcedureType getDefaultProcedureType() {
            return DBSProcedureType.FUNCTION;
        }

        protected void updateProcedureType(DBSProcedureType type) {
            this.returnTypeCombo.setEnabled(type.hasReturnValue());
        }

        protected void createExtraControls(Composite group) {
            ArrayList languages = new ArrayList();
            try {
                languages.addAll(this.parent.getDatabase().getLanguages(this.monitor));
            }
            catch (DBException e2) {
                log.error((Object)e2);
            }
            Combo languageCombo = UIUtils.createLabelCombo((Composite)group, (String)"Language", (int)12);
            for (PostgreLanguage lang : languages) {
                languageCombo.add(lang.getName());
            }
            languageCombo.addModifyListener(e -> {
                this.language = (PostgreLanguage)languages.get(languageCombo.getSelectionIndex());
            });
            languageCombo.setText("sql");
            ArrayList<PostgreDataType> dataTypes = new ArrayList<PostgreDataType>(this.parent.getDatabase().getLocalDataTypes());
            dataTypes.sort(Comparator.comparing(PostgreDataType::getName));
            this.returnTypeCombo = UIUtils.createLabelCombo((Composite)group, (String)"Return type", (int)4);
            for (PostgreDataType dt : dataTypes) {
                this.returnTypeCombo.add(dt.getName());
            }
            this.returnTypeCombo.addModifyListener(e -> {
                String dtName = this.returnTypeCombo.getText();
                this.returnType = !CommonUtils.isEmpty((String)dtName) ? this.parent.getDatabase().getLocalDataType(dtName) : null;
            });
            this.returnTypeCombo.setText("int4");
        }

        public PostgreLanguage getLanguage() {
            return this.language;
        }

        public PostgreDataType getReturnType() {
            return this.returnType;
        }
    }
}

