/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.lang.invoke.CallSite;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class LocaleSelectorControl
extends Composite {
    private final Combo languageCombo;
    private final Combo countryCombo;
    private final Combo variantCombo;
    private final Text localeText;
    private Locale currentLocale;
    private boolean localeChanging = false;

    public LocaleSelectorControl(Composite parent, Locale defaultLocale) {
        super(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        Composite group = UIUtils.createTitledComposite(this, UIMessages.controls_locale_selector_group_locale, 2, 1808);
        UIUtils.createControlLabel(group, UIMessages.controls_locale_selector_label_language);
        this.languageCombo = new Combo(group, 4);
        this.languageCombo.setLayoutData((Object)new GridData(768));
        this.languageCombo.addModifyListener(e -> {
            this.onLanguageChange(null);
            this.calculateLocale();
        });
        UIUtils.createControlLabel(group, UIMessages.controls_locale_selector_label_country);
        this.countryCombo = new Combo(group, 4);
        this.countryCombo.setLayoutData((Object)new GridData(768));
        this.countryCombo.addModifyListener(e -> {
            this.onCountryChange(null);
            this.calculateLocale();
        });
        UIUtils.createControlLabel(group, UIMessages.controls_locale_selector_label_variant);
        this.variantCombo = new Combo(group, 4);
        this.variantCombo.setLayoutData((Object)new GridData(768));
        this.variantCombo.addModifyListener(e -> this.calculateLocale());
        UIUtils.createControlLabel(group, UIMessages.controls_locale_selector_label_locale);
        this.localeText = new Text(group, 2056);
        this.localeText.setLayoutData((Object)new GridData(768));
        Locale[] locales = Locale.getAvailableLocales();
        TreeSet<CallSite> languages = new TreeSet<CallSite>();
        for (Locale locale : locales) {
            languages.add((CallSite)((Object)(locale.getLanguage() + " - " + locale.getDisplayLanguage())));
        }
        this.currentLocale = defaultLocale;
        if (this.currentLocale == null) {
            this.currentLocale = Locale.getDefault();
        }
        for (String string : languages) {
            this.languageCombo.add(string);
            if (!LocaleSelectorControl.getIsoCode(string).equals(this.currentLocale.getLanguage())) continue;
            this.languageCombo.select(this.languageCombo.getItemCount() - 1);
        }
        this.onLanguageChange(this.currentLocale.getCountry());
        this.onCountryChange(this.currentLocale.getVariant());
    }

    private static String getIsoCode(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isLetter(value.charAt(i))) continue;
            return value.substring(0, i);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLocaleChange() {
        try {
            int i;
            this.localeChanging = true;
            int count = this.languageCombo.getItemCount();
            boolean found = false;
            for (i = 0; i < count; ++i) {
                if (!LocaleSelectorControl.getIsoCode(this.languageCombo.getItem(i)).equals(this.currentLocale.getLanguage())) continue;
                this.languageCombo.select(i);
                found = true;
                break;
            }
            if (!found) {
                this.languageCombo.setText(this.currentLocale.getLanguage());
            }
            this.onLanguageChange(this.currentLocale.getLanguage());
            count = this.countryCombo.getItemCount();
            found = false;
            for (i = 0; i < count; ++i) {
                if (!LocaleSelectorControl.getIsoCode(this.countryCombo.getItem(i)).equals(this.currentLocale.getCountry())) continue;
                this.countryCombo.select(i);
                found = true;
                break;
            }
            if (!found) {
                this.countryCombo.setText(this.currentLocale.getCountry());
            }
            this.onCountryChange(this.currentLocale.getCountry());
            this.variantCombo.setText(this.currentLocale.getVariant());
        }
        finally {
            this.localeChanging = false;
        }
        this.calculateLocale();
    }

    private void onLanguageChange(String defCountry) {
        String language = LocaleSelectorControl.getIsoCode(this.languageCombo.getText());
        Locale[] locales = Locale.getAvailableLocales();
        this.countryCombo.removeAll();
        TreeSet<CallSite> countries = new TreeSet<CallSite>();
        for (Locale locale : locales) {
            if (!language.equals(locale.getLanguage()) || CommonUtils.isEmpty((String)locale.getCountry())) continue;
            countries.add((CallSite)((Object)(locale.getCountry() + " - " + locale.getDisplayCountry())));
        }
        if (defCountry == null) {
            defCountry = this.currentLocale.getCountry();
        }
        for (String string : countries) {
            this.countryCombo.add(string);
            if (defCountry == null || !defCountry.equals(LocaleSelectorControl.getIsoCode(string))) continue;
            this.countryCombo.select(this.countryCombo.getItemCount() - 1);
        }
        if (defCountry == null && this.countryCombo.getItemCount() > 0) {
            this.countryCombo.select(0);
        }
    }

    private void onCountryChange(String defVariant) {
        String language = LocaleSelectorControl.getIsoCode(this.languageCombo.getText());
        String country = LocaleSelectorControl.getIsoCode(this.countryCombo.getText());
        Locale[] locales = Locale.getAvailableLocales();
        this.variantCombo.removeAll();
        TreeSet<Object> variants = new TreeSet<Object>();
        for (Locale locale : locales) {
            if (!language.equals(locale.getLanguage()) || !country.equals(locale.getCountry()) || CommonUtils.isEmpty((String)locale.getVariant())) continue;
            if (locale.getVariant().equals(locale.getDisplayVariant())) {
                variants.add(locale.getVariant());
                continue;
            }
            variants.add(locale.getVariant() + " - " + locale.getDisplayVariant());
        }
        if (defVariant == null) {
            defVariant = this.currentLocale.getVariant();
        }
        for (String string : variants) {
            this.variantCombo.add(string);
            if (defVariant == null || !defVariant.equals(LocaleSelectorControl.getIsoCode(string))) continue;
            this.variantCombo.select(this.variantCombo.getItemCount() - 1);
        }
        if (defVariant == null && this.variantCombo.getItemCount() > 0) {
            this.variantCombo.select(0);
        }
    }

    private void calculateLocale() {
        if (this.localeChanging) {
            return;
        }
        String language = LocaleSelectorControl.getIsoCode(this.languageCombo.getText());
        String country = LocaleSelectorControl.getIsoCode(this.countryCombo.getText());
        String variant = LocaleSelectorControl.getIsoCode(this.variantCombo.getText());
        this.currentLocale = Locale.of(language, country, variant);
        this.localeText.setText(this.currentLocale.toString());
        Event event = new Event();
        event.data = this.currentLocale;
        super.notifyListeners(13, event);
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
        this.onLocaleChange();
    }

    public Locale getSelectedLocale() {
        return this.currentLocale;
    }

    public void setEnabled(boolean enabled) {
        this.languageCombo.setEnabled(enabled);
        this.countryCombo.setEnabled(enabled);
        this.variantCombo.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

