/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2ObjectType;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2View;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;

public final class DB2ViewCache
extends JDBCStructLookupCache<DB2Schema, DB2View, DB2TableColumn> {
    private static final String SQL_COLS_TAB = "SELECT * FROM SYSCAT.COLUMNS WHERE TABSCHEMA=? AND TABNAME = ? ORDER BY COLNO WITH UR";
    private static final String SQL_COLS_ALL = "SELECT * FROM SYSCAT.COLUMNS WHERE TABSCHEMA=? ORDER BY TABNAME, COLNO WITH UR";
    private static final String SQL_VIEW;
    private static final String SQL_VIEW_ALL;

    public DB2ViewCache() {
        super((Object)"TABNAME");
    }

    @NotNull
    public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull DB2Schema db2Schema, @Nullable DB2View db2View, @Nullable String db2ViewName) throws SQLException {
        if (db2View != null || db2ViewName != null) {
            JDBCPreparedStatement dbStat = session.prepareStatement(SQL_VIEW);
            dbStat.setString(1, db2Schema.getName());
            dbStat.setString(2, db2View != null ? db2View.getName() : db2ViewName);
            return dbStat;
        }
        JDBCPreparedStatement dbStat = session.prepareStatement(SQL_VIEW_ALL);
        dbStat.setString(1, db2Schema.getName());
        return dbStat;
    }

    protected DB2View fetchObject(@NotNull JDBCSession session, @NotNull DB2Schema db2Schema, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return new DB2View(session.getProgressMonitor(), db2Schema, (ResultSet)dbResult);
    }

    protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull DB2Schema db2Schema, @Nullable DB2View forView) throws SQLException {
        String sql = forView != null ? SQL_COLS_TAB : SQL_COLS_ALL;
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, db2Schema.getName());
        if (forView != null) {
            dbStat.setString(2, forView.getName());
        }
        return dbStat;
    }

    protected DB2TableColumn fetchChild(@NotNull JDBCSession session, @NotNull DB2Schema db2Schema, @NotNull DB2View db2View, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return new DB2TableColumn(session.getProgressMonitor(), db2View, (ResultSet)dbResult);
    }

    static {
        StringBuilder sb = new StringBuilder(256);
        sb.append("SELECT *");
        sb.append(" FROM SYSCAT.TABLES T");
        sb.append("    , SYSCAT.VIEWS V");
        sb.append(" WHERE V.VIEWSCHEMA = ?");
        sb.append("   AND T.TABSCHEMA = V.VIEWSCHEMA");
        sb.append("   AND T.TABNAME = V.VIEWNAME");
        sb.append("   AND T.TYPE IN ").append(DB2TableType.getInClause(DB2ObjectType.VIEW));
        sb.append(" ORDER BY T.TABNAME");
        sb.append(" WITH UR");
        SQL_VIEW_ALL = sb.toString();
        sb.setLength(0);
        sb.append("SELECT *");
        sb.append(" FROM SYSCAT.TABLES T");
        sb.append("    , SYSCAT.VIEWS V");
        sb.append(" WHERE V.VIEWSCHEMA = ?");
        sb.append("   AND V.VIEWNAME = ?");
        sb.append("   AND T.TABSCHEMA = V.VIEWSCHEMA");
        sb.append("   AND T.TABNAME = V.VIEWNAME");
        sb.append("   AND T.TYPE IN ").append(DB2TableType.getInClause(DB2ObjectType.VIEW));
        sb.append(" WITH UR");
        SQL_VIEW = sb.toString();
    }
}

