/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSPageRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.MarginRule;
import io.sf.carte.doc.style.css.om.MarginRuleList;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.w3c.dom.DOMException;

public class PageRule
extends BaseCSSDeclarationRule
implements CSSPageRule {
    private static final long serialVersionUID = 1L;
    private PageSelectorList selectorList = null;
    private MarginRuleList marginRules = null;

    public PageRule(AbstractCSSStyleSheet parentSheet, int origin) {
        super(parentSheet, (short)6, origin);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(30 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0 || this.getStyle().getLength() != 0 || this.marginRules != null) {
            StringBuilder buf = new StringBuilder(96);
            buf.append("@page");
            if (seltext.length() != 0) {
                buf.append(' ').append(seltext);
            }
            String styleText = this.getStyle().getMinifiedCssText();
            buf.append('{').append(styleText);
            if (this.marginRules != null) {
                if (styleText.length() != 0) {
                    buf.append(';');
                }
                for (MarginRule rule : this.marginRules) {
                    buf.append(rule.getMinifiedCssText());
                }
            }
            buf.append('}');
            return buf.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        String seltext = this.getSelectorText();
        if (seltext.length() != 0 || this.getStyle().getLength() != 0 || this.marginRules != null) {
            context.startRule(wri, this.getPrecedingComments());
            wri.write((CharSequence)"@page");
            if (seltext.length() != 0) {
                wri.write(' ');
                wri.write((CharSequence)seltext);
            }
            context.updateContext(this);
            context.writeLeftCurlyBracket(wri);
            context.startStyleDeclaration(wri);
            this.getStyle().writeCssText(wri, context);
            context.endCurrentContext(this);
            context.endStyleDeclaration(wri);
            if (this.marginRules != null) {
                context.updateContext(this);
                for (MarginRule rule : this.marginRules) {
                    rule.writeCssText(wri, context);
                }
                context.endCurrentContext(this);
                context.endRuleList(wri);
            }
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, this.getTrailingComments());
        }
    }

    public PageSelectorList getSelectorList() {
        return this.selectorList;
    }

    void setSelectorList(PageSelectorList selectorList) {
        this.selectorList = selectorList;
    }

    @Override
    public String getSelectorText() {
        return this.selectorList == null ? "" : this.selectorList.toString();
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        CSSParser parser = new CSSParser();
        this.selectorList = parser.parsePageSelectorList(selectorText);
    }

    void addMarginRule(MarginRule marginRule) {
        if (this.marginRules == null) {
            this.marginRules = new MarginRuleList(8);
        }
        this.marginRules.add(marginRule);
    }

    public MarginRuleList getMarginRules() {
        return this.marginRules;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.marginRules, this.selectorList);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRule other = (PageRule)obj;
        return Objects.equals(this.marginRules, other.marginRules) && Objects.equals(this.selectorList, other.selectorList);
    }

    @Override
    public PageRule clone(AbstractCSSStyleSheet parentSheet) {
        PageRule clon = new PageRule(parentSheet, this.getOrigin());
        clon.selectorList = this.selectorList;
        if (this.marginRules != null) {
            clon.marginRules = new MarginRuleList(this.marginRules.size());
            Iterator it = this.marginRules.iterator();
            while (it.hasNext()) {
                clon.marginRules.add(((MarginRule)it.next()).clone(parentSheet));
            }
        }
        String oldHrefContext = this.getParentStyleSheet().getHref();
        clon.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return clon;
    }
}

