/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.action;

import com.intellij.debugger.streams.core.StreamDebuggerBundle;
import com.intellij.debugger.streams.core.action.ChainResolver;
import com.intellij.debugger.streams.core.action.ChainStatus;
import com.intellij.debugger.streams.core.action.TraceStreamRunner;
import com.intellij.debugger.streams.core.action.TraceStreamUIScope;
import com.intellij.debugger.streams.core.diagnostic.ex.TraceCompilationException;
import com.intellij.debugger.streams.core.diagnostic.ex.TraceEvaluationException;
import com.intellij.debugger.streams.core.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.core.psi.DebuggerPositionResolver;
import com.intellij.debugger.streams.core.psi.impl.DebuggerPositionResolverImpl;
import com.intellij.debugger.streams.core.trace.DebuggerCommandLauncher;
import com.intellij.debugger.streams.core.trace.EvaluateExpressionTracer;
import com.intellij.debugger.streams.core.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.core.trace.StreamTracer;
import com.intellij.debugger.streams.core.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.core.trace.XValueInterpreter;
import com.intellij.debugger.streams.core.trace.impl.TraceResultInterpreterImpl;
import com.intellij.debugger.streams.core.ui.ChooserOption;
import com.intellij.debugger.streams.core.ui.ElementChooser;
import com.intellij.debugger.streams.core.ui.impl.ElementChooserImpl;
import com.intellij.debugger.streams.core.ui.impl.EvaluationAwareTraceWindow;
import com.intellij.debugger.streams.core.wrapper.StreamChain;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0082@\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/debugger/streams/core/action/TraceStreamRunner;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myPositionResolver", "Lcom/intellij/debugger/streams/core/psi/DebuggerPositionResolver;", "getChainStatus", "Lcom/intellij/debugger/streams/core/action/ChainStatus;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "actionPerformed", "Lkotlinx/coroutines/Job;", "displayChains", "", "chains", "", "Lcom/intellij/debugger/streams/core/action/ChainResolver$StreamChainWithLibrary;", "(Lcom/intellij/xdebugger/XDebugSession;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getChains", "(Lcom/intellij/xdebugger/XDebugSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MyStreamChainChooser", "StreamChainOption", "Companion", "intellij.debugger.streams.core"})
public final class TraceStreamRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final DebuggerPositionResolver myPositionResolver;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ChainResolver CHAIN_RESOLVER;

    public TraceStreamRunner(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.myPositionResolver = new DebuggerPositionResolverImpl();
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @NotNull
    public final ChainStatus getChainStatus(@Nullable XDebugSession session) {
        PsiElement element;
        PsiElement psiElement = element = session == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        if (element == null) {
            return ChainStatus.NOT_FOUND;
        }
        return CHAIN_RESOLVER.tryFindChain(element);
    }

    @NotNull
    public final Job actionPerformed(@Nullable XDebugSession session) {
        return BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, this, null){
            Object L$0;
            int label;
            final /* synthetic */ XDebugSession $session;
            final /* synthetic */ TraceStreamRunner this$0;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$session == null) {
                            TraceStreamRunner.access$getLOG$cp().info("Session is null");
                            return Unit.INSTANCE;
                        }
                        this.label = 1;
                        v0 = TraceStreamRunner.access$getChains(this.this$0, this.$session, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        chains = (List)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)chains);
                        this.label = 2;
                        v1 = TraceStreamRunner.access$displayChains(this.this$0, this.$session, chains, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        chains = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final Object displayChains(XDebugSession session, List<ChainResolver.StreamChainWithLibrary> chains2, Continuation<? super Unit> $completion) {
        if (chains2.isEmpty()) {
            LOG.warn("Stream chain is not built");
            return Unit.INSTANCE;
        }
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(chains2, session, this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ List<ChainResolver.StreamChainWithLibrary> $chains;
            final /* synthetic */ XDebugSession $session;
            final /* synthetic */ TraceStreamRunner this$0;
            {
                this.$chains = $chains;
                this.$session = $session;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$chains.size() != 1) break;
                        this.label = 1;
                        v0 = com.intellij.debugger.streams.core.action.TraceStreamRunner$Companion.access$runTrace(TraceStreamRunner.Companion, ((ChainResolver.StreamChainWithLibrary)CollectionsKt.first(this.$chains)).chain, ((ChainResolver.StreamChainWithLibrary)CollectionsKt.first(this.$chains)).provider, this.$session, (Continuation)this);
                        if (v0 == var16_2) {
                            return var16_2;
                        }
                        ** GOTO lbl51
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl51
                    }
                }
                v1 = this.$session.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                project = v1;
                file = ((ChainResolver.StreamChainWithLibrary)CollectionsKt.first(this.$chains)).chain.getContext().getContainingFile().getVirtualFile();
                v2 = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file), true);
                if (v2 == null) {
                    throw new IllegalStateException(("Cannot open editor for file: " + file.getName()).toString());
                }
                editor = v2;
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)file);
                this.L$2 = editor;
                this.label = 2;
                v3 = YieldKt.yield((Continuation)((Continuation)this));
                if (v3 == var16_2) {
                    return var16_2;
                }
                ** GOTO lbl37
                {
                    case 2: {
                        editor = (Editor)this.L$2;
                        file = (VirtualFile)this.L$1;
                        project = (Project)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl37:
                        // 2 sources

                        var5_6 = this.$chains;
                        var14_7 = new MyStreamChainChooser(editor);
                        $i$f$map = false;
                        var7_9 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var12_14 = (ChainResolver.StreamChainWithLibrary)item$iv$iv;
                            var15_16 = destination$iv$iv;
                            $i$a$-map-TraceStreamRunner$displayChains$2$1 = false;
                            var15_16.add(new StreamChainOption((ChainResolver.StreamChainWithLibrary)it));
                        }
                        var14_7.show((List)destination$iv$iv, (ElementChooser.CallBack<StreamChainOption>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$1(com.intellij.debugger.streams.core.action.TraceStreamRunner com.intellij.xdebugger.XDebugSession com.intellij.debugger.streams.core.action.TraceStreamRunner$StreamChainOption ), (Lcom/intellij/debugger/streams/core/action/TraceStreamRunner$StreamChainOption;)V)((TraceStreamRunner)this.this$0, (XDebugSession)this.$session));
lbl51:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$1(TraceStreamRunner this$0, XDebugSession $session, StreamChainOption provider) {
                BuildersKt.launch$default((CoroutineScope)this$0.getCs(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(provider, $session, null){
                    int label;
                    final /* synthetic */ StreamChainOption $provider;
                    final /* synthetic */ XDebugSession $session;
                    {
                        this.$provider = $provider;
                        this.$session = $session;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = com.intellij.debugger.streams.core.action.TraceStreamRunner$Companion.access$runTrace(TraceStreamRunner.Companion, this.$provider.getChain(), this.$provider.getProvider(), this.$session, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getChains(XDebugSession session, Continuation<? super List<ChainResolver.StreamChainWithLibrary>> $completion) {
        if (!($completion instanceof getChains.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ TraceStreamRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TraceStreamRunner.access$getChains(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getChains$lambda$0(com.intellij.debugger.streams.core.action.TraceStreamRunner com.intellij.xdebugger.XDebugSession ), ()Ljava/util/List;)((TraceStreamRunner)this, (XDebugSession)session), (Continuation)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                session = (XDebugSession)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                chains = (List)v0;
                return chains;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final List getChains$lambda$0(TraceStreamRunner this$0, XDebugSession $session) {
        return (List)com.intellij.openapi.progress.CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ChainResolver.StreamChainWithLibrary>>, Object>(this$0, $session, null){
            Object L$0;
            int label;
            final /* synthetic */ TraceStreamRunner this$0;
            final /* synthetic */ XDebugSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        element = TraceStreamRunner.access$getMyPositionResolver$p(this.this$0).getNearestElementToBreakpoint(this.$session);
                        if (element != null) ** GOTO lbl10
                        TraceStreamRunner.access$getLOG$cp().info("Element at cursor is not found");
                        v0 = CollectionsKt.emptyList();
                        ** GOTO lbl25
lbl10:
                        // 1 sources

                        v1 = this.$session.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
                        v2 = StreamDebuggerBundle.message("action.calculating.chains.background.progress.title", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)element);
                        this.label = 1;
                        v3 = TasksKt.withBackgroundProgress((Project)v1, (String)v2, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ChainResolver.StreamChainWithLibrary>>, Object>(element, null){
                            int label;
                            final /* synthetic */ PsiElement $element;
                            {
                                this.$element = $element;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        return TraceStreamRunner.access$getCHAIN_RESOLVER$cp().getChains$intellij_debugger_streams_core(this.$element);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super List<ChainResolver.StreamChainWithLibrary>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v3 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        element = (PsiElement)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl24:
                        // 2 sources

                        v0 = (List)v3;
lbl25:
                        // 2 sources

                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<ChainResolver.StreamChainWithLibrary>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Object access$getChains(TraceStreamRunner $this, XDebugSession session, Continuation $completion) {
        return $this.getChains(session, (Continuation<? super List<ChainResolver.StreamChainWithLibrary>>)$completion);
    }

    public static final /* synthetic */ Object access$displayChains(TraceStreamRunner $this, XDebugSession session, List chains2, Continuation $completion) {
        return $this.displayChains(session, chains2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ DebuggerPositionResolver access$getMyPositionResolver$p(TraceStreamRunner $this) {
        return $this.myPositionResolver;
    }

    public static final /* synthetic */ ChainResolver access$getCHAIN_RESOLVER$cp() {
        return CHAIN_RESOLVER;
    }

    static {
        Logger logger = Logger.getInstance(TraceStreamRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        CHAIN_RESOLVER = new ChainResolver();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0015R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/debugger/streams/core/action/TraceStreamRunner$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/debugger/streams/core/action/TraceStreamRunner;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "CHAIN_RESOLVER", "Lcom/intellij/debugger/streams/core/action/ChainResolver;", "runTrace", "", "chain", "Lcom/intellij/debugger/streams/core/wrapper/StreamChain;", "provider", "Lcom/intellij/debugger/streams/core/lib/LibrarySupportProvider;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/debugger/streams/core/wrapper/StreamChain;Lcom/intellij/debugger/streams/core/lib/LibrarySupportProvider;Lcom/intellij/xdebugger/XDebugSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.debugger.streams.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TraceStreamRunner getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TraceStreamRunner.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TraceStreamRunner)object;
        }

        private final Object runTrace(StreamChain chain, LibrarySupportProvider provider, XDebugSession session, Continuation<? super Unit> $completion) {
            Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, chain, provider, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ XDebugSession $session;
                final /* synthetic */ StreamChain $chain;
                final /* synthetic */ LibrarySupportProvider $provider;
                {
                    this.$session = $session;
                    this.$chain = $chain;
                    this.$provider = $provider;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            window = new EvaluationAwareTraceWindow(this.$session, this.$chain);
                            Disposer.register((Disposable)window.getDisposable(), (Disposable)(Disposable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0(kotlinx.coroutines.CoroutineScope ), ()V)((CoroutineScope)$this$coroutineScope));
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                            this.L$1 = window;
                            this.label = 1;
                            v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(window, null){
                                int label;
                                final /* synthetic */ EvaluationAwareTraceWindow $window;
                                {
                                    this.$window = $window;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            v0 = YieldKt.yield((Continuation)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            this.$window.show();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v0 == var4_3) {
                                return var4_3;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            window = (EvaluationAwareTraceWindow)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            v1 = Dispatchers.getDefault();
                            v2 = window.getDisposable();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDisposable(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)window);
                            this.label = 2;
                            v3 = BuildersKt.withContext((CoroutineContext)v1.plus((CoroutineContext)new TraceStreamUIScope(v2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$session, this.$provider, this.$chain, window, null){
                                int label;
                                final /* synthetic */ XDebugSession $session;
                                final /* synthetic */ LibrarySupportProvider $provider;
                                final /* synthetic */ StreamChain $chain;
                                final /* synthetic */ EvaluationAwareTraceWindow $window;
                                {
                                    this.$session = $session;
                                    this.$provider = $provider;
                                    this.$chain = $chain;
                                    this.$window = $window;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Project project = this.$session.getProject();
                                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                                            Project project2 = project;
                                            TraceExpressionBuilder traceExpressionBuilder = this.$provider.getExpressionBuilder(project2);
                                            Intrinsics.checkNotNullExpressionValue((Object)traceExpressionBuilder, (String)"getExpressionBuilder(...)");
                                            TraceExpressionBuilder expressionBuilder = traceExpressionBuilder;
                                            TraceResultInterpreterImpl resultInterpreter = new TraceResultInterpreterImpl(this.$provider.getLibrarySupport().getInterpreterFactory());
                                            XValueInterpreter xValueInterpreter = this.$provider.getXValueInterpreter(project2);
                                            Intrinsics.checkNotNullExpressionValue((Object)xValueInterpreter, (String)"getXValueInterpreter(...)");
                                            XValueInterpreter xValueInterpreter2 = xValueInterpreter;
                                            DebuggerCommandLauncher debuggerCommandLauncher = this.$provider.getDebuggerCommandLauncher(this.$session);
                                            Intrinsics.checkNotNullExpressionValue((Object)debuggerCommandLauncher, (String)"getDebuggerCommandLauncher(...)");
                                            DebuggerCommandLauncher debuggerLauncher = debuggerCommandLauncher;
                                            StreamTracer tracer = new EvaluateExpressionTracer(this.$session, expressionBuilder, resultInterpreter, xValueInterpreter2);
                                            debuggerLauncher.launchDebuggerCommand((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tracer, this.$chain, this.$provider, this.$window, debuggerLauncher, project2, null){
                                                Object L$0;
                                                Object L$1;
                                                int label;
                                                final /* synthetic */ StreamTracer $tracer;
                                                final /* synthetic */ StreamChain $chain;
                                                final /* synthetic */ LibrarySupportProvider $provider;
                                                final /* synthetic */ EvaluationAwareTraceWindow $window;
                                                final /* synthetic */ DebuggerCommandLauncher $debuggerLauncher;
                                                final /* synthetic */ Project $project;
                                                {
                                                    this.$tracer = $tracer;
                                                    this.$chain = $chain;
                                                    this.$provider = $provider;
                                                    this.$window = $window;
                                                    this.$debuggerLauncher = $debuggerLauncher;
                                                    this.$project = $project;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Unable to fully structure code
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    block13: {
                                                        block15: {
                                                            block14: {
                                                                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                switch (this.label) {
                                                                    case 0: {
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        this.label = 1;
                                                                        v0 = this.$tracer.trace(this.$chain, (Continuation<? super StreamTracer.Result>)((Continuation)this));
                                                                        if (v0 == var5_2) {
                                                                            return var5_2;
                                                                        }
                                                                        ** GOTO lbl13
                                                                    }
                                                                    case 1: {
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v0 = $result;
lbl13:
                                                                        // 2 sources

                                                                        if (!((var3_5 = (result = (StreamTracer.Result)v0)) instanceof StreamTracer.Result.Evaluated)) break;
                                                                        v1 = ((StreamTracer.Result.Evaluated)result).getResult().resolve(this.$provider.getLibrarySupport().getResolverFactory());
                                                                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"resolve(...)");
                                                                        resolvedTrace = v1;
                                                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)result);
                                                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)resolvedTrace);
                                                                        this.label = 2;
                                                                        v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$window, resolvedTrace, this.$debuggerLauncher, result, this.$provider, this.$project, null){
                                                                            int label;
                                                                            final /* synthetic */ EvaluationAwareTraceWindow $window;
                                                                            final /* synthetic */ ResolvedTracingResult $resolvedTrace;
                                                                            final /* synthetic */ DebuggerCommandLauncher $debuggerLauncher;
                                                                            final /* synthetic */ StreamTracer.Result $result;
                                                                            final /* synthetic */ LibrarySupportProvider $provider;
                                                                            final /* synthetic */ Project $project;
                                                                            {
                                                                                this.$window = $window;
                                                                                this.$resolvedTrace = $resolvedTrace;
                                                                                this.$debuggerLauncher = $debuggerLauncher;
                                                                                this.$result = $result;
                                                                                this.$provider = $provider;
                                                                                this.$project = $project;
                                                                                super(2, $completion);
                                                                            }

                                                                            public final Object invokeSuspend(Object $result) {
                                                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                                switch (this.label) {
                                                                                    case 0: {
                                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                                        this.$window.setTrace(this.$resolvedTrace, this.$debuggerLauncher, ((StreamTracer.Result.Evaluated)this.$result).getEvaluationContext(), this.$provider.getCollectionTreeBuilder(this.$project));
                                                                                        return Unit.INSTANCE;
                                                                                    }
                                                                                }
                                                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                            }

                                                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                                            }

                                                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                            }
                                                                        }), (Continuation)((Continuation)this));
                                                                        if (v2 == var5_2) {
                                                                            return var5_2;
                                                                        }
                                                                        break block13;
                                                                    }
                                                                    case 2: {
                                                                        resolvedTrace = (ResolvedTracingResult)this.L$1;
                                                                        result = (StreamTracer.Result)this.L$0;
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v2 = $result;
                                                                        break block13;
                                                                    }
                                                                }
                                                                if (!(var3_5 instanceof StreamTracer.Result.EvaluationFailed)) break block14;
                                                                this.L$0 = result;
                                                                this.label = 3;
                                                                v3 = runTrace.2.access$invokeSuspend$showError(this.$window, ((StreamTracer.Result.EvaluationFailed)result).getMessage(), (Continuation)this);
                                                                if (v3 == var5_2) {
                                                                    return var5_2;
                                                                }
                                                                ** GOTO lbl41
                                                                {
                                                                    case 3: {
                                                                        result = (StreamTracer.Result)this.L$0;
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v3 = $result;
lbl41:
                                                                        // 2 sources

                                                                        throw new TraceEvaluationException(((StreamTracer.Result.EvaluationFailed)result).getMessage(), ((StreamTracer.Result.EvaluationFailed)result).getTraceExpression());
                                                                    }
                                                                }
                                                            }
                                                            if (!(var3_5 instanceof StreamTracer.Result.CompilationFailed)) break block15;
                                                            this.L$0 = result;
                                                            this.label = 4;
                                                            v4 = runTrace.2.access$invokeSuspend$showError(this.$window, ((StreamTracer.Result.CompilationFailed)result).getMessage(), (Continuation)this);
                                                            if (v4 == var5_2) {
                                                                return var5_2;
                                                            }
                                                            ** GOTO lbl54
                                                            {
                                                                case 4: {
                                                                    result = (StreamTracer.Result)this.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v4 = $result;
lbl54:
                                                                    // 2 sources

                                                                    throw new TraceCompilationException(((StreamTracer.Result.CompilationFailed)result).getMessage(), ((StreamTracer.Result.CompilationFailed)result).getTraceExpression());
                                                                }
                                                            }
                                                        }
                                                        if (Intrinsics.areEqual((Object)var3_5, (Object)StreamTracer.Result.Unknown.INSTANCE)) {
                                                            TraceStreamRunner.access$getLOG$cp().error("Unknown result");
                                                        } else {
                                                            throw new NoWhenBranchMatchedException();
                                                        }
                                                    }
                                                    return Unit.INSTANCE;
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v3 == var4_3) {
                                return var4_3;
                            }
                            ** GOTO lbl33
                        }
                        case 2: {
                            window = (EvaluationAwareTraceWindow)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl33:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda$0(CoroutineScope $$this$coroutineScope) {
                    CoroutineScopeKt.cancel$default((CoroutineScope)$$this$coroutineScope, null, (int)1, null);
                }

                private static final Object invokeSuspend$showError(EvaluationAwareTraceWindow window, String message, Continuation<? super Unit> $completion) {
                    Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(window, message, null){
                        int label;
                        final /* synthetic */ EvaluationAwareTraceWindow $window;
                        final /* synthetic */ String $message;
                        {
                            this.$window = $window;
                            this.$message = $message;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.$window.setFailMessage(this.$message);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }

                public static final /* synthetic */ Object access$invokeSuspend$showError(EvaluationAwareTraceWindow window, String message, Continuation $completion) {
                    return runTrace.2.invokeSuspend$showError(window, message, (Continuation<? super Unit>)$completion);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$runTrace(Companion $this, StreamChain chain, LibrarySupportProvider provider, XDebugSession session, Continuation $completion) {
            return $this.runTrace(chain, provider, session, (Continuation<? super Unit>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/debugger/streams/core/action/TraceStreamRunner$MyStreamChainChooser;", "Lcom/intellij/debugger/streams/core/ui/impl/ElementChooserImpl;", "Lcom/intellij/debugger/streams/core/action/TraceStreamRunner$StreamChainOption;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "intellij.debugger.streams.core"})
    private static final class MyStreamChainChooser
    extends ElementChooserImpl<StreamChainOption> {
        public MyStreamChainChooser(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(editor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/debugger/streams/core/action/TraceStreamRunner$StreamChainOption;", "Lcom/intellij/debugger/streams/core/ui/ChooserOption;", "chain", "Lcom/intellij/debugger/streams/core/action/ChainResolver$StreamChainWithLibrary;", "<init>", "(Lcom/intellij/debugger/streams/core/action/ChainResolver$StreamChainWithLibrary;)V", "Lcom/intellij/debugger/streams/core/wrapper/StreamChain;", "getChain", "()Lcom/intellij/debugger/streams/core/wrapper/StreamChain;", "provider", "Lcom/intellij/debugger/streams/core/lib/LibrarySupportProvider;", "getProvider", "()Lcom/intellij/debugger/streams/core/lib/LibrarySupportProvider;", "rangeStream", "Ljava/util/stream/Stream;", "Lcom/intellij/openapi/util/TextRange;", "getText", "", "intellij.debugger.streams.core"})
    private static final class StreamChainOption
    implements ChooserOption {
        @NotNull
        private final StreamChain chain;
        @NotNull
        private final LibrarySupportProvider provider;

        public StreamChainOption(@NotNull ChainResolver.StreamChainWithLibrary chain) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            this.chain = chain.chain;
            this.provider = chain.provider;
        }

        @NotNull
        public final StreamChain getChain() {
            return this.chain;
        }

        @NotNull
        public final LibrarySupportProvider getProvider() {
            return this.provider;
        }

        @Override
        @NotNull
        public Stream<TextRange> rangeStream() {
            Stream<TextRange> stream = Stream.of(new TextRange(this.chain.getQualifierExpression().getTextRange().getStartOffset(), this.chain.getTerminationCall().getTextRange().getEndOffset()));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
            return stream;
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.chain.getCompactText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCompactText(...)");
            return string;
        }
    }
}

