/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.Content;
import com.intellij.history.core.DataStreamUtil;
import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DeleteChange
extends StructuralChange {
    private final Entry myDeletedEntry;

    public DeleteChange(long id, String path, Entry deletedEntry) {
        super(id, path);
        this.myDeletedEntry = deletedEntry;
    }

    public DeleteChange(DataInput in) throws IOException {
        super(in);
        this.myDeletedEntry = DataStreamUtil.readEntry(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        DataStreamUtil.writeEntry(out, this.myDeletedEntry);
    }

    public Entry getDeletedEntry() {
        return this.myDeletedEntry;
    }

    @Override
    public void revertOn(RootEntry root, boolean warnOnFileNotFound) {
        String parentPath = Paths.getParentOf(this.myPath);
        Entry parent = root.findEntry(parentPath);
        if (parent == null) {
            this.cannotRevert(parentPath, warnOnFileNotFound);
            return;
        }
        parent.addChild(this.myDeletedEntry.copy());
    }

    public boolean isDeletionOf(String p) {
        String relative = Paths.relativeIfUnder(p, this.myPath);
        if (relative == null) {
            return false;
        }
        return this.myDeletedEntry.hasEntry(relative);
    }

    @Override
    public List<Content> getContentsToPurge() {
        ArrayList<Content> result = new ArrayList<Content>();
        DeleteChange.collectContentsRecursively(this.myDeletedEntry, result);
        return result;
    }

    private static void collectContentsRecursively(Entry e, List<? super Content> result) {
        if (e.isDirectory()) {
            for (Entry child : e.getChildren()) {
                DeleteChange.collectContentsRecursively(child, result);
            }
        } else {
            result.add(e.getContent());
        }
    }

    @Override
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

