/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Map;
import javajs.util.A4;
import javajs.util.BS;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BSUtil;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Vibration
extends V3 {
    protected static final double twoPI = Math.PI * 2;
    public static final int TYPE_VIBRATION = -1;
    public static final int TYPE_SPIN = -2;
    public static final int TYPE_WYCKOFF = -3;
    public int modDim = -1;
    public float modScale = Float.NaN;
    public float magMoment;
    public boolean showTrace;
    public boolean isFractional;
    public V3 v0;
    public int tracePt;
    private P3[] trace = null;
    public String symmform;
    public boolean isFrom000;
    private final M3 matTemp = new M3();
    private final M3 matInv = new M3();

    public T3 setCalcPoint(T3 pt, T3 t456, float scale, float modulationScale) {
        switch (this.modDim) {
            case -3: 
            case -2: {
                break;
            }
            default: {
                pt.scaleAdd2((float)(Math.cos((double)t456.x * (Math.PI * 2)) * (double)scale), this, pt);
            }
        }
        return pt;
    }

    public void getInfo(Map<String, Object> info) {
        info.put("vibVector", V3.newV(this));
        info.put("vibType", this.modDim == -2 ? "spin" : (this.modDim == -1 ? "vib" : "mod"));
    }

    public Object clone() {
        Vibration v = new Vibration();
        v.setT(this);
        v.modDim = this.modDim;
        v.magMoment = this.magMoment;
        v.v0 = this.v0;
        return v;
    }

    public void setXYZ(T3 vib) {
        this.setT(vib);
    }

    public void setV0() {
        this.v0 = V3.newV(this);
    }

    public Vibration setType(int type) {
        this.modDim = type;
        return this;
    }

    public boolean isNonzero() {
        return this.x != 0.0f || this.y != 0.0f || this.z != 0.0f;
    }

    public int getOccupancy100(boolean isTemp) {
        return Integer.MIN_VALUE;
    }

    public void startTrace(int n) {
        this.trace = new P3[n];
        this.tracePt = n;
    }

    public P3[] addTracePt(int n, Point3fi ptNew) {
        if (this.trace == null || n == 0 || n != this.trace.length) {
            this.startTrace(n);
        }
        if (ptNew != null && n > 2) {
            P3 p;
            if (--this.tracePt <= 0) {
                P3 p0 = this.trace[this.trace.length - 1];
                int i = this.trace.length;
                while (--i >= 1) {
                    this.trace[i] = this.trace[i - 1];
                }
                this.trace[1] = p0;
                this.tracePt = 1;
            }
            if ((p = this.trace[this.tracePt]) == null) {
                p = this.trace[this.tracePt] = new P3();
            }
            p.setT(ptNew);
        }
        return this.trace;
    }

    public String getApproxString100() {
        return Math.round(this.x * 100.0f) + "," + Math.round(this.y * 100.0f) + "," + Math.round(this.z * 100.0f);
    }

    public void rotateSpin(M3 matInv, M3 rot, M3 dRot, Atom a) {
        Vibration.rot(matInv, rot, dRot, this);
        if (this.isFrom000) {
            Vibration.rot(matInv, rot, dRot, a);
        }
    }

    private static void rot(M3 matInv, M3 rot, M3 dRot, T3 t) {
        if (matInv == null) {
            dRot.rotate(t);
        } else {
            matInv.rotate(t);
            rot.rotate(t);
        }
    }

    public int rotateModelSpinVectors(ModelSet ms, int modelIndex, M3 rot, boolean isdx) {
        M3 matInv;
        float deg;
        if (modelIndex < 0 || modelIndex >= ms.mc || ms.vibrations == null) {
            return -1;
        }
        Viewer vwr = ms.vwr;
        Model m = ms.am[modelIndex];
        if (m.isJmolDataFrame) {
            modelIndex = m.dataSourceFrame;
        }
        Map<String, Object> info = ms.getModelAuxiliaryInfo(modelIndex);
        if (rot == null && (rot = (M3)info.get("spinFrameRotationMatrix")) == null) {
            return -1;
        }
        boolean noref = Double.isNaN(rot.getElement(0, 0));
        boolean isScreenZ = noref && rot.getElement(2, 2) == 1.0f;
        float f = deg = noref || isScreenZ ? rot.getElement(1, 1) : 0.0f;
        if (noref && deg != 0.0f) {
            rot.setElement(1, 1, 0.0f);
            this.rotateModelSpinVectors(ms, modelIndex, rot, false);
            rot.setElement(1, 1, deg);
        }
        M3 m0 = (M3)info.get("spinFrameRotationMatrix");
        M3 mat = (M3)info.get("spinRotationMatrixApplied");
        if (mat == null && m0 == null) {
            m0 = M3.newM3(null);
            info.put("spinFrameRotationMatrix", m0);
        }
        if (mat == null) {
            mat = m0;
        }
        if (noref) {
            V3 qn;
            if (isScreenZ) {
                P3 pt3 = P3.new3(0.0f, 0.0f, 100.0f);
                P3 pt4 = P3.new3(0.0f, 0.0f, 200.0f);
                vwr.tm.unTransformPoint(pt3, pt3);
                vwr.tm.unTransformPoint(pt4, pt4);
                qn = V3.newVsub(pt3, pt4);
            } else {
                qn = Quat.newM(mat).getNormal();
            }
            rot = Quat.newVA(qn, deg).getMatrix();
        }
        BS bs = BSUtil.newAndSetBit(modelIndex);
        ms.includeAllRelatedFrames(bs, true);
        BS bsModels = BSUtil.copy(bs);
        bs = vwr.getModelUndeletedAtomsBitSetBs(bs);
        M3 drot = this.matTemp;
        if (isdx) {
            drot.setM3(rot);
            rot.mul2(rot, mat);
            matInv = null;
        } else {
            matInv = this.matInv;
            matInv.setM3(mat);
            matInv.invert();
        }
        int i = bs.nextSetBit(0);
        while (i >= 0 && i < ms.vibrations.length) {
            Vibration v = ms.vibrations[i];
            if (v != null && (v.isFrom000 || v.magMoment != 0.0f)) {
                v.rotateSpin(matInv, rot, drot, ms.at[i]);
            }
            i = bs.nextSetBit(i + 1);
        }
        Quat quat = Quat.newM(rot);
        A4 aa = quat.toAxisAngle4f();
        mat = M3.newM3(rot);
        info.put("spinRotationMatrixApplied", mat);
        int jmolSpinModel = -1;
        int i2 = bsModels.nextSetBit(0);
        while (i2 >= 0) {
            m = ms.am[i2];
            if (m.uvw0 != null) {
                jmolSpinModel = i2;
                mat.rotate2(m.uvw0[0], m.uvw[0]);
                mat.rotate2(m.uvw0[1], m.uvw[1]);
                mat.rotate2(m.uvw0[2], m.uvw[2]);
            }
            i2 = bsModels.nextSetBit(i2 + 1);
        }
        info.put("spinRotationAxisAngleApplied", aa);
        if (ms.unitCells[modelIndex] != null) {
            ms.unitCells[modelIndex].setSpinAxisAngle(aa);
        }
        return jmolSpinModel;
    }

    public static Atom find(ModelSet modelSet, BS bs, Vibration v0) {
        if (v0 != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                Vibration v = modelSet.getVibration(i, false);
                if (v != null && (double)v.distance(v0) < 0.1) {
                    return modelSet.at[i];
                }
                i = bs.nextSetBit(i + 1);
            }
        }
        return null;
    }
}

