/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAUtil;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509Key;

public final class RSAPublicKeyImpl
extends X509Key
implements RSAPublicKey {
    private static final long serialVersionUID = 2644735423591199609L;
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private BigInteger n;
    private BigInteger e;
    private AlgorithmParameterSpec keyParams;

    public static RSAPublicKey newKey(byte[] byArray) throws InvalidKeyException {
        return new RSAPublicKeyImpl(byArray);
    }

    public static RSAPublicKey newKey(RSAUtil.KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        AlgorithmId algorithmId = RSAUtil.createAlgorithmId(keyType, algorithmParameterSpec);
        return new RSAPublicKeyImpl(algorithmId, bigInteger, bigInteger2);
    }

    RSAPublicKeyImpl(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        RSAKeyFactory.checkRSAProviderKeyLengths(bigInteger.bitLength(), bigInteger2);
        RSAPublicKeyImpl.checkExponentRange(bigInteger, bigInteger2);
        this.n = bigInteger;
        this.e = bigInteger2;
        this.keyParams = RSAUtil.getParamSpec(algorithmId);
        this.algid = algorithmId;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            byte[] byArray = new DerValue(48, derOutputStream.toByteArray()).toByteArray();
            this.setKey(new BitArray(byArray.length * 8, byArray));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    RSAPublicKeyImpl(byte[] byArray) throws InvalidKeyException {
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Missing key encoding");
        }
        this.decode(byArray);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
        RSAPublicKeyImpl.checkExponentRange(this.n, this.e);
        try {
            this.keyParams = RSAUtil.getParamSpec(this.algid);
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
    }

    static void checkExponentRange(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new InvalidKeyException("exponent is larger than modulus");
        }
        if (bigInteger2.compareTo(THREE) < 0) {
            throw new InvalidKeyException("exponent is smaller than 3");
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.getKey().toByteArray());
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream derInputStream2 = derValue.data;
            this.n = derInputStream2.getPositiveBigInteger();
            this.e = derInputStream2.getPositiveBigInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("Extra data available");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid RSA public key", iOException);
        }
    }

    @Override
    public String toString() {
        return "Sun " + this.getAlgorithm() + " public key, " + this.n.bitLength() + " bits\n  params: " + this.keyParams + "\n  modulus: " + this.n + "\n  public exponent: " + this.e;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("RSAPublicKeyImpl keys are not directly deserializable");
    }
}

