/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.spi.runtime.MethodDescription;
import java.util.HashMap;
import java.util.Map;

public abstract class AuthorizationPolicyStorage {
    protected AuthorizationPolicyStorage() {
    }

    protected abstract Map<MethodDescription, String> getMethodToPolicyName();

    public boolean requiresAuthorizationPolicy(MethodDescription securedMethodDesc) {
        if (securedMethodDesc == null) {
            return false;
        }
        return this.getMethodToPolicyName().containsKey(securedMethodDesc);
    }

    public static final class MethodsToPolicyBuilder {
        private final Map<MethodDescription, String> methodToPolicyName = new HashMap<MethodDescription, String>();

        public MethodsToPolicyBuilder addMethodToPolicyName(String policyName, String className, String methodName, String[] parameterTypes) {
            this.methodToPolicyName.put(new MethodDescription(className, methodName, parameterTypes), policyName);
            return this;
        }

        public Map<MethodDescription, String> build() {
            return Map.copyOf(this.methodToPolicyName);
        }
    }
}

