<?php

declare(strict_types=1);

/**
 * SPDX-FileCopyrightText: 2019 Nextcloud GmbH and Nextcloud contributors
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */
namespace OCA\Files_Versions\Listener;

use OCA\Files\Event\LoadAdditionalScriptsEvent;
use OCA\Files_Versions\AppInfo\Application;
use OCP\EventDispatcher\Event;
use OCP\EventDispatcher\IEventListener;
use OCP\Util;

/** @template-implements IEventListener<LoadAdditionalScriptsEvent> */
class LoadAdditionalListener implements IEventListener {
	public function handle(Event $event): void {
		if (!($event instanceof LoadAdditionalScriptsEvent)) {
			return;
		}

		// TODO: make sure to only include the sidebar script when
		// we properly split it between files list and sidebar
		Util::addStyle(Application::APP_ID, 'sidebar-tab');
		Util::addInitScript(Application::APP_ID, 'sidebar-tab');
	}
}
