/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.action.node;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.alerting.core.action.node.ScheduledJobStats;
import org.opensearch.alerting.core.settings.LegacyOpenDistroScheduledJobSettings;
import org.opensearch.alerting.core.settings.ScheduledJobSettings;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007BG\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0006\u0010\u0013J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsResponse;", "Lorg/opensearch/action/support/nodes/BaseNodesResponse;", "Lorg/opensearch/alerting/core/action/node/ScheduledJobStats;", "Lorg/opensearch/core/xcontent/ToXContentFragment;", "si", "Lorg/opensearch/core/common/io/stream/StreamInput;", "<init>", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "clusterName", "Lorg/opensearch/cluster/ClusterName;", "nodeResponses", "", "failures", "Lorg/opensearch/action/FailedNodeException;", "scheduledJobEnabled", "", "indexExists", "indexHealth", "Lorg/opensearch/cluster/health/ClusterIndexHealth;", "(Lorg/opensearch/cluster/ClusterName;Ljava/util/List;Ljava/util/List;ZZLorg/opensearch/cluster/health/ClusterIndexHealth;)V", "Ljava/lang/Boolean;", "writeNodesTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "nodes", "", "readNodesFrom", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "alerting-core"})
@SourceDebugExtension(value={"SMAP\nScheduledJobsStatsResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduledJobsStatsResponse.kt\norg/opensearch/alerting/core/action/node/ScheduledJobsStatsResponse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1788#2,4:80\n1788#2,4:84\n*S KotlinDebug\n*F\n+ 1 ScheduledJobsStatsResponse.kt\norg/opensearch/alerting/core/action/node/ScheduledJobsStatsResponse\n*L\n64#1:80,4\n65#1:84,4\n*E\n"})
public final class ScheduledJobsStatsResponse
extends BaseNodesResponse<ScheduledJobStats>
implements ToXContentFragment {
    private boolean scheduledJobEnabled;
    @Nullable
    private Boolean indexExists;
    @Nullable
    private ClusterIndexHealth indexHealth;

    public ScheduledJobsStatsResponse(@NotNull StreamInput si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        super(si);
        this.scheduledJobEnabled = si.readBoolean();
        this.indexExists = si.readBoolean();
        this.indexHealth = (ClusterIndexHealth)si.readOptionalWriteable(arg_0 -> ScheduledJobsStatsResponse._init_$lambda$0(si, arg_0));
    }

    public ScheduledJobsStatsResponse(@NotNull ClusterName clusterName, @NotNull List<ScheduledJobStats> nodeResponses, @NotNull List<? extends FailedNodeException> failures, boolean scheduledJobEnabled, boolean indexExists, @Nullable ClusterIndexHealth indexHealth) {
        Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
        Intrinsics.checkNotNullParameter(nodeResponses, (String)"nodeResponses");
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
        super(clusterName, nodeResponses, failures);
        this.scheduledJobEnabled = scheduledJobEnabled;
        this.indexExists = indexExists;
        this.indexHealth = indexHealth;
    }

    protected void writeNodesTo(@NotNull StreamOutput out, @NotNull List<ScheduledJobStats> nodes) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        out.writeList(nodes);
    }

    @NotNull
    protected List<ScheduledJobStats> readNodesFrom(@NotNull StreamInput si) {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        List list = si.readList(ScheduledJobsStatsResponse::readNodesFrom$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        return list;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        int n;
        int n2;
        String string;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.field(LegacyOpenDistroScheduledJobSettings.Companion.getSWEEPER_ENABLED().getKey(), this.scheduledJobEnabled);
        builder.field(ScheduledJobSettings.Companion.getSWEEPER_ENABLED().getKey(), this.scheduledJobEnabled);
        builder.field("scheduled_job_index_exists", this.indexExists);
        Object object = this.indexHealth;
        if (object != null && (object = object.getStatus()) != null && (object = object.name()) != null) {
            String string2 = ((String)object).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        builder.field("scheduled_job_index_status", string);
        List list = this.getNodes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNodes(...)");
        Iterable $this$count$iv = list;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ScheduledJobStats it = (ScheduledJobStats)((Object)element$iv);
                boolean bl = false;
                if (!(it.getStatus() == ScheduledJobStats.ScheduleStatus.GREEN) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int nodesOnSchedule = n2;
        List list2 = this.getNodes();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getNodes(...)");
        Iterable $this$count$iv2 = list2;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                ScheduledJobStats it = (ScheduledJobStats)((Object)element$iv);
                boolean bl = false;
                if (!(it.getStatus() == ScheduledJobStats.ScheduleStatus.RED) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int nodesNotOnSchedule = n;
        builder.field("nodes_on_schedule", nodesOnSchedule);
        builder.field("nodes_not_on_schedule", nodesNotOnSchedule);
        builder.startObject("nodes");
        for (ScheduledJobStats scheduledJobStatus : this.getNodes()) {
            builder.startObject(scheduledJobStatus.getNode().getId());
            scheduledJobStatus.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static final ClusterIndexHealth _init_$lambda$0(StreamInput $si, StreamInput it) {
        return new ClusterIndexHealth($si);
    }

    private static final ScheduledJobStats readNodesFrom$lambda$1(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return ScheduledJobStats.Companion.readScheduledJobStatus(it);
    }
}

