"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MDSEnabledClientService = void 0;
class MDSEnabledClientService {
  static getClient(request, context, dataSourceEnabled) {
    const {
      dataSourceId = ""
    } = request.query || {};
    if (dataSourceEnabled && dataSourceId && dataSourceId.trim().length != 0) {
      return context.dataSource.opensearch.legacy.getClient(dataSourceId.toString()).callAPI;
    } else {
      // fall back to default local cluster
      return context.notificationsContext.notificationsClient.asScoped(request).callAsCurrentUser;
    }
  }
}
exports.MDSEnabledClientService = MDSEnabledClientService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJNRFNFbmFibGVkQ2xpZW50U2VydmljZSIsImdldENsaWVudCIsInJlcXVlc3QiLCJjb250ZXh0IiwiZGF0YVNvdXJjZUVuYWJsZWQiLCJkYXRhU291cmNlSWQiLCJxdWVyeSIsInRyaW0iLCJsZW5ndGgiLCJkYXRhU291cmNlIiwib3BlbnNlYXJjaCIsImxlZ2FjeSIsInRvU3RyaW5nIiwiY2FsbEFQSSIsIm5vdGlmaWNhdGlvbnNDb250ZXh0Iiwibm90aWZpY2F0aW9uc0NsaWVudCIsImFzU2NvcGVkIiwiY2FsbEFzQ3VycmVudFVzZXIiLCJleHBvcnRzIl0sInNvdXJjZXMiOlsiTURTRW5hYmxlZENsaWVudFNlcnZpY2UudHMiXSwic291cmNlc0NvbnRlbnQiOlsiXG5leHBvcnQgY2xhc3MgTURTRW5hYmxlZENsaWVudFNlcnZpY2Uge1xuICBzdGF0aWMgZ2V0Q2xpZW50KHJlcXVlc3QsIGNvbnRleHQsIGRhdGFTb3VyY2VFbmFibGVkKSB7XG4gICAgY29uc3QgeyBkYXRhU291cmNlSWQgPSBcIlwiIH0gPSAocmVxdWVzdC5xdWVyeSB8fCB7fSkgYXMgeyBkYXRhU291cmNlSWQ/OiBzdHJpbmcgfTtcbiAgICBpZiAoZGF0YVNvdXJjZUVuYWJsZWQgJiYgZGF0YVNvdXJjZUlkICYmIGRhdGFTb3VyY2VJZC50cmltKCkubGVuZ3RoICE9IDApIHtcbiAgICAgIHJldHVybiBjb250ZXh0LmRhdGFTb3VyY2Uub3BlbnNlYXJjaC5sZWdhY3kuZ2V0Q2xpZW50KGRhdGFTb3VyY2VJZC50b1N0cmluZygpKS5jYWxsQVBJO1xuICAgIH0gZWxzZSB7XG4gICAgICAvLyBmYWxsIGJhY2sgdG8gZGVmYXVsdCBsb2NhbCBjbHVzdGVyXG4gICAgICByZXR1cm4gY29udGV4dC5ub3RpZmljYXRpb25zQ29udGV4dC5ub3RpZmljYXRpb25zQ2xpZW50LmFzU2NvcGVkKFxuICAgICAgICByZXF1ZXN0LFxuICAgICAgKS5jYWxsQXNDdXJyZW50VXNlcjtcbiAgICB9XG4gIH1cbn1cblxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDTyxNQUFNQSx1QkFBdUIsQ0FBQztFQUNuQyxPQUFPQyxTQUFTQSxDQUFDQyxPQUFPLEVBQUVDLE9BQU8sRUFBRUMsaUJBQWlCLEVBQUU7SUFDcEQsTUFBTTtNQUFFQyxZQUFZLEdBQUc7SUFBRyxDQUFDLEdBQUlILE9BQU8sQ0FBQ0ksS0FBSyxJQUFJLENBQUMsQ0FBK0I7SUFDaEYsSUFBSUYsaUJBQWlCLElBQUlDLFlBQVksSUFBSUEsWUFBWSxDQUFDRSxJQUFJLENBQUMsQ0FBQyxDQUFDQyxNQUFNLElBQUksQ0FBQyxFQUFFO01BQ3hFLE9BQU9MLE9BQU8sQ0FBQ00sVUFBVSxDQUFDQyxVQUFVLENBQUNDLE1BQU0sQ0FBQ1YsU0FBUyxDQUFDSSxZQUFZLENBQUNPLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQ0MsT0FBTztJQUN4RixDQUFDLE1BQU07TUFDTDtNQUNBLE9BQU9WLE9BQU8sQ0FBQ1csb0JBQW9CLENBQUNDLG1CQUFtQixDQUFDQyxRQUFRLENBQzlEZCxPQUNGLENBQUMsQ0FBQ2UsaUJBQWlCO0lBQ3JCO0VBQ0Y7QUFDRjtBQUFDQyxPQUFBLENBQUFsQix1QkFBQSxHQUFBQSx1QkFBQSJ9