/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.opensearchapi;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.NoShardAvailableActionException;
import org.opensearch.action.admin.indices.rollover.RolloverInfo;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.indexstatemanagement.settings.LegacyOpenDistroManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a0\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u000f\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011*\u0010\u0012\u0004\u0012\u0002H\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u00110\u000f\u001a(\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u00070\u0013*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0086@\u00a2\u0006\u0002\u0010\u0017\u001a>\u0010\u0018\u001a \u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\f\u0012\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001b\u0018\u00010\u00130\u0019*\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019H\u0086@\u00a2\u0006\u0002\u0010\u001d\u001a2\u0010\u001e\u001a&\u0012\u0004\u0012\u00020\u0004\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\f\u0012\n\u0018\u00010\u001aj\u0004\u0018\u0001`\u001b\u0018\u00010\u00130\u000f2\u0006\u0010\u001f\u001a\u00020 \u001a\u0014\u0010!\u001a\u00020\"2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019\u001a.\u0010#\u001a\u00020$*\u00020$2\u0006\u0010%\u001a\u00020\u00042\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020\u0007\u001a\"\u0010+\u001a\u00020$*\u00020$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)\u001a\f\u0010,\u001a\u0004\u0018\u00010-*\u00020\u0005\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getRolloverAlias", "", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "getRolloverSkip", "", "getUuidsForClosedIndices", "", "state", "Lorg/opensearch/cluster/ClusterState;", "defaultIndexMetadataService", "Lorg/opensearch/indexmanagement/indexstatemanagement/DefaultIndexMetadataService;", "filterNotNullValues", "", "K", "V", "getManagedIndexMetadata", "Lkotlin/Pair;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "Lorg/opensearch/transport/client/Client;", "indexUUID", "(Lorg/opensearch/transport/client/Client;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mgetManagedIndexMetadata", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "indexUuids", "(Lorg/opensearch/transport/client/Client;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mgetResponseToMap", "mgetResponse", "Lorg/opensearch/action/get/MultiGetResponse;", "buildMgetMetadataRequest", "Lorg/opensearch/action/get/MultiGetRequest;", "addObject", "Lorg/opensearch/core/xcontent/XContentBuilder;", "name", "metadata", "Lorg/opensearch/core/xcontent/ToXContentFragment;", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "forIndex", "buildMetadata", "getOldestRolloverTime", "Ljava/time/Instant;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nOpenSearchExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSearchExtensions.kt\norg/opensearch/indexmanagement/indexstatemanagement/opensearchapi/OpenSearchExtensionsKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n216#2,2:199\n126#2:210\n153#2,3:211\n504#3,7:201\n1869#4,2:208\n1869#4,2:216\n13472#5,2:214\n1#6:218\n*S KotlinDebug\n*F\n+ 1 OpenSearchExtensions.kt\norg/opensearch/indexmanagement/indexstatemanagement/opensearchapi/OpenSearchExtensionsKt\n*L\n67#1:199,2\n140#1:210\n140#1:211,3\n78#1:201,7\n130#1:208,2\n176#1:216,2\n160#1:214,2\n*E\n"})
public final class OpenSearchExtensionsKt {
    private static final Logger log = LogManager.getLogger((String)"Index Management Helper");

    @Nullable
    public static final String getRolloverAlias(@NotNull IndexMetadata $this$getRolloverAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$getRolloverAlias, (String)"<this>");
        CharSequence charSequence = $this$getRolloverAlias.getSettings().get(ManagedIndexSettings.Companion.getROLLOVER_ALIAS().getKey());
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = $this$getRolloverAlias.getSettings().get(LegacyOpenDistroManagedIndexSettings.Companion.getROLLOVER_ALIAS().getKey());
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : $this$getRolloverAlias.getSettings().get(LegacyOpenDistroManagedIndexSettings.Companion.getROLLOVER_ALIAS().getKey());
        }
        return $this$getRolloverAlias.getSettings().get(ManagedIndexSettings.Companion.getROLLOVER_ALIAS().getKey());
    }

    public static final boolean getRolloverSkip(@NotNull IndexMetadata $this$getRolloverSkip) {
        Intrinsics.checkNotNullParameter((Object)$this$getRolloverSkip, (String)"<this>");
        CharSequence charSequence = $this$getRolloverSkip.getSettings().get(ManagedIndexSettings.Companion.getROLLOVER_SKIP().getKey());
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Boolean bl = $this$getRolloverSkip.getSettings().getAsBoolean(LegacyOpenDistroManagedIndexSettings.Companion.getROLLOVER_SKIP().getKey(), Boolean.valueOf(false));
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getAsBoolean(...)");
            return bl;
        }
        Boolean bl = $this$getRolloverSkip.getSettings().getAsBoolean(ManagedIndexSettings.Companion.getROLLOVER_SKIP().getKey(), Boolean.valueOf(false));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getAsBoolean(...)");
        return bl;
    }

    @NotNull
    public static final List<String> getUuidsForClosedIndices(@NotNull ClusterState state, @NotNull DefaultIndexMetadataService defaultIndexMetadataService) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)defaultIndexMetadataService, (String)"defaultIndexMetadataService");
        Map indexMetadatas = state.getMetadata().getIndices();
        List closeList = new ArrayList();
        Intrinsics.checkNotNull((Object)indexMetadatas);
        Map $this$forEach$iv = indexMetadatas;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            if (((IndexMetadata)it.getValue()).getState() != IndexMetadata.State.CLOSE) continue;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            closeList.add(defaultIndexMetadataService.getIndexUUID((IndexMetadata)v));
        }
        return closeList;
    }

    @NotNull
    public static final <K, V> Map<K, V> filterNotNullValues(@NotNull Map<K, ? extends V> $this$filterNotNullValues) {
        Intrinsics.checkNotNullParameter($this$filterNotNullValues, (String)"<this>");
        Map<K, V> $this$filterValues$iv = $this$filterNotNullValues;
        boolean $i$f$filterValues = false;
        LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
            V it = entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getManagedIndexMetadata(@NotNull Client $this$getManagedIndexMetadata, @NotNull String indexUUID, @NotNull Continuation<? super Pair<ManagedIndexMetaData, Boolean>> $completion) {
        if (!($completion instanceof getManagedIndexMetadata.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSearchExtensionsKt.getManagedIndexMetadata(null, null, (Continuation<? super Pair<ManagedIndexMetaData, Boolean>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                getRequest = new GetRequest(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(indexUUID)).routing(indexUUID);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getManagedIndexMetadata);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexUUID);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)getRequest);
                $continuation.label = 1;
                v0 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$getManagedIndexMetadata, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getManagedIndexMetadata$lambda$2(org.opensearch.action.get.GetRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((GetRequest)getRequest), $continuation);
                ** if (v0 != var8_5) goto lbl22
lbl21:
                // 1 sources

                return var8_5;
lbl22:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                getRequest = (GetRequest)$continuation.L$2;
                indexUUID = (String)$continuation.L$1;
                $this$getManagedIndexMetadata = (Client)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                if (!(getResponse = (GetResponse)v0).isExists() || getResponse.isSourceEmpty()) {
                    return new Pair(null, (Object)Boxing.boxBoolean((boolean)true));
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getManagedIndexMetadata);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)indexUUID);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)getRequest);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)getResponse);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ManagedIndexMetaData>, Object>(getResponse, null){
                    int label;
                    final /* synthetic */ GetResponse $getResponse;
                    {
                        this.$getResponse = $getResponse;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)this.$getResponse.getSourceAsBytesRef(), (MediaType)((MediaType)XContentType.JSON));
                                Intrinsics.checkNotNull((Object)xcp);
                                String string = this.$getResponse.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                                return ManagedIndexMetaData.Companion.parseWithType(xcp, string, this.$getResponse.getSeqNo(), this.$getResponse.getPrimaryTerm());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ManagedIndexMetaData> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var8_5) goto lbl41
lbl40:
                // 1 sources

                return var8_5;
lbl41:
                // 1 sources

                ** GOTO lbl51
            }
            case 2: {
                getResponse = (GetResponse)$continuation.L$3;
                getRequest = (GetRequest)$continuation.L$2;
                indexUUID = (String)$continuation.L$1;
                $this$getManagedIndexMetadata = (Client)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl51:
                    // 2 sources

                    metadata = (ManagedIndexMetaData)v1;
                    return new Pair((Object)metadata, (Object)Boxing.boxBoolean((boolean)true));
                }
                catch (Exception e) {
                    var5_12 = e;
                    if (var5_12 instanceof IndexNotFoundException || var5_12 instanceof NoShardAvailableActionException) {
                        OpenSearchExtensionsKt.log.error("Failed to get metadata because no index or shard not available");
                    } else {
                        OpenSearchExtensionsKt.log.error("Failed to get metadata", (Throwable)e);
                    }
                    return new Pair(null, (Object)Boxing.boxBoolean((boolean)false));
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object mgetManagedIndexMetadata(@NotNull Client $this$mgetManagedIndexMetadata, @NotNull List<String> indexUuids, @NotNull Continuation<? super List<? extends Pair<ManagedIndexMetaData, ? extends Exception>>> $completion) {
        if (!($completion instanceof mgetManagedIndexMetadata.1)) ** GOTO lbl-1000
        var17_3 = $completion;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSearchExtensionsKt.mgetManagedIndexMetadata(null, null, (Continuation<? super List<? extends Pair<ManagedIndexMetaData, ? extends Exception>>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                OpenSearchExtensionsKt.log.debug("trying to get back metadata for index [" + indexUuids + "]");
                if (indexUuids.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                mgetRequest = new MultiGetRequest();
                $this$forEach$iv = indexUuids;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    $i$a$-forEach-OpenSearchExtensionsKt$mgetManagedIndexMetadata$2 = false;
                    mgetRequest.add(new MultiGetRequest.Item(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID((String)it)).routing((String)it));
                }
                mgetMetadataList = CollectionsKt.emptyList();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$mgetManagedIndexMetadata);
                $continuation.L$1 = indexUuids;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)mgetRequest);
                $continuation.L$3 = mgetMetadataList;
                $continuation.label = 1;
                v0 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this$mgetManagedIndexMetadata, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, mgetManagedIndexMetadata$lambda$4(org.opensearch.action.get.MultiGetRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((MultiGetRequest)mgetRequest), $continuation);
                ** if (v0 != var18_5) goto lbl36
lbl35:
                // 1 sources

                return var18_5;
lbl36:
                // 1 sources

                ** GOTO lbl46
            }
            case 1: {
                mgetMetadataList = (List)$continuation.L$3;
                mgetRequest = (MultiGetRequest)$continuation.L$2;
                indexUuids = (List)$continuation.L$1;
                $this$mgetManagedIndexMetadata = (Client)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl46:
                    // 2 sources

                    response = (MultiGetResponse)v0;
                    $this$map$iv = OpenSearchExtensionsKt.mgetResponseToMap(response);
                    $i$f$map = false;
                    it = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                    $i$f$mapTo = false;
                    var11_19 = $this$mapTo$iv$iv.entrySet().iterator();
                    while (var11_19.hasNext()) {
                        var13_21 = item$iv$iv = var11_19.next();
                        var15_23 = destination$iv$iv;
                        $i$a$-map-OpenSearchExtensionsKt$mgetManagedIndexMetadata$3 = false;
                        var15_23.add((Pair)it.getValue());
                    }
                    mgetMetadataList = (List)destination$iv$iv;
                }
                catch (ActionRequestValidationException e) {
                    OpenSearchExtensionsKt.log.info("No managed index metadata for indices [" + indexUuids + "], " + e.getMessage());
                }
                catch (Exception e) {
                    OpenSearchExtensionsKt.log.error("Failed to multi-get managed index metadata for indices [" + indexUuids + "]", (Throwable)e);
                }
                return mgetMetadataList;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final Map<String, Pair<ManagedIndexMetaData, Exception>> mgetResponseToMap(@NotNull MultiGetResponse mgetResponse) {
        Intrinsics.checkNotNullParameter((Object)mgetResponse, (String)"mgetResponse");
        Map mgetMap = new LinkedHashMap();
        MultiGetItemResponse[] multiGetItemResponseArray = mgetResponse.getResponses();
        Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"getResponses(...)");
        Object[] $this$forEach$iv = multiGetItemResponseArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MultiGetItemResponse it = (MultiGetItemResponse)element$iv;
            boolean bl = false;
            if (it.isFailed()) {
                mgetMap.put(it.getId(), new Pair(null, (Object)it.getFailure().getFailure()));
                continue;
            }
            if (it.getResponse() != null && !it.getResponse().isSourceEmpty()) {
                BytesReference bytesReference = it.getResponse().getSourceAsBytesRef();
                Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"getSourceAsBytesRef(...)");
                XContentParser xcp = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.contentParser$default(bytesReference, null, 2, null);
                Map map = mgetMap;
                String string = it.getId();
                String string2 = it.getResponse().getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                Pair pair = new Pair((Object)ManagedIndexMetaData.Companion.parseWithType(xcp, string2, it.getResponse().getSeqNo(), it.getResponse().getPrimaryTerm()), null);
                map.put(string, pair);
                continue;
            }
            mgetMap.put(it.getId(), null);
        }
        return mgetMap;
    }

    @NotNull
    public static final MultiGetRequest buildMgetMetadataRequest(@NotNull List<String> indexUuids) {
        Intrinsics.checkNotNullParameter(indexUuids, (String)"indexUuids");
        MultiGetRequest mgetMetadataRequest = new MultiGetRequest();
        Iterable $this$forEach$iv = indexUuids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            mgetMetadataRequest.add(new MultiGetRequest.Item(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(it)).routing(it));
        }
        return mgetMetadataRequest;
    }

    @NotNull
    public static final XContentBuilder addObject(@NotNull XContentBuilder $this$addObject, @NotNull String name, @Nullable ToXContentFragment metadata2, @NotNull ToXContent.Params params, boolean forIndex) {
        XContentBuilder xContentBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$addObject, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (metadata2 != null) {
            return OpenSearchExtensionsKt.buildMetadata($this$addObject, name, metadata2, params);
        }
        if (forIndex) {
            XContentBuilder xContentBuilder2 = $this$addObject.nullField(name);
            xContentBuilder = xContentBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"nullField(...)");
        } else {
            xContentBuilder = $this$addObject;
        }
        return xContentBuilder;
    }

    public static /* synthetic */ XContentBuilder addObject$default(XContentBuilder xContentBuilder, String string, ToXContentFragment toXContentFragment, ToXContent.Params params, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return OpenSearchExtensionsKt.addObject(xContentBuilder, string, toXContentFragment, params, bl);
    }

    @NotNull
    public static final XContentBuilder buildMetadata(@NotNull XContentBuilder $this$buildMetadata, @NotNull String name, @NotNull ToXContentFragment metadata2, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)$this$buildMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        $this$buildMetadata.startObject(name);
        metadata2.toXContent($this$buildMetadata, params);
        $this$buildMetadata.endObject();
        return $this$buildMetadata;
    }

    @Nullable
    public static final Instant getOldestRolloverTime(@NotNull IndexMetadata $this$getOldestRolloverTime) {
        Instant instant;
        Comparable comparable;
        Intrinsics.checkNotNullParameter((Object)$this$getOldestRolloverTime, (String)"<this>");
        Iterator iterator = ((Iterable)$this$getOldestRolloverTime.getRolloverInfos().values()).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            RolloverInfo it = (RolloverInfo)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getTime());
            while (iterator.hasNext()) {
                Object it2 = (RolloverInfo)iterator.next();
                $i$a$-minOfOrNull-OpenSearchExtensionsKt$getOldestRolloverTime$1 = false;
                if (comparable2.compareTo(it2 = (Comparable)Long.valueOf(it2.getTime())) <= 0) continue;
                comparable2 = it2;
            }
            comparable = comparable2;
        }
        Long l = (Long)comparable;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            instant = Instant.ofEpochMilli(it);
        } else {
            instant = null;
        }
        return instant;
    }

    private static final Unit getManagedIndexMetadata$lambda$2(GetRequest $getRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.get($getRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit mgetManagedIndexMetadata$lambda$4(MultiGetRequest $mgetRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.multiGet($mgetRequest, it);
        return Unit.INSTANCE;
    }
}

