/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaRef;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import com.networknt.schema.utils.JsonSchemaRefs;
import com.networknt.schema.utils.SetView;
import com.networknt.schema.walk.WalkListenerRunner;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesValidator
extends BaseJsonValidator {
    public static final String PROPERTY = "properties";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesValidator.class);
    private final Map<String, JsonSchema> schemas = new LinkedHashMap<String, JsonSchema>();
    private Boolean hasUnevaluatedPropertiesValidator;

    public PropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTIES, validationContext);
        Iterator it = schemaNode.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String pname = (String)entry.getKey();
            this.schemas.put(pname, validationContext.newSchema(schemaLocation.append(pname), evaluationPath.append(pname), (JsonNode)entry.getValue(), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    protected Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean walk) {
        PropertiesValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        SetView<ValidationMessage> errors = null;
        LinkedHashSet<String> matchedInstancePropertyNames = null;
        boolean collectAnnotations = this.collectAnnotations() || this.collectAnnotations(executionContext);
        for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
            JsonNode propertyNode = node.get(entry.getKey());
            if (propertyNode != null) {
                JsonNodePath path = instanceLocation.append(entry.getKey());
                if (collectAnnotations) {
                    if (matchedInstancePropertyNames == null) {
                        matchedInstancePropertyNames = new LinkedHashSet<String>();
                    }
                    matchedInstancePropertyNames.add(entry.getKey());
                }
                if (!walk) {
                    Set<ValidationMessage> result = entry.getValue().validate(executionContext, propertyNode, rootNode, path);
                    if (result.isEmpty()) continue;
                    if (errors == null) {
                        errors = new SetView();
                    }
                    errors.union(result);
                    continue;
                }
                if (errors == null) {
                    errors = new SetView();
                }
                this.walkSchema(executionContext, entry, node, rootNode, instanceLocation, true, errors, this.validationContext.getConfig().getPropertyWalkListenerRunner());
                continue;
            }
            if (!walk) continue;
            if (errors == null) {
                errors = new SetView<ValidationMessage>();
            }
            this.walkSchema(executionContext, entry, node, rootNode, instanceLocation, true, errors, this.validationContext.getConfig().getPropertyWalkListenerRunner());
        }
        if (collectAnnotations) {
            executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(matchedInstancePropertyNames == null ? Collections.emptySet() : matchedInstancePropertyNames).build());
        }
        return errors == null || errors.isEmpty() ? Collections.emptySet() : errors;
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        SetView<ValidationMessage> validationMessages = new SetView<ValidationMessage>();
        if (this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyPropertyDefaults() && null != node && node.getNodeType() == JsonNodeType.OBJECT) {
            this.applyPropertyDefaults((ObjectNode)node);
        }
        if (shouldValidateSchema) {
            validationMessages.union(this.validate(executionContext, (JsonNode)(node == null ? MissingNode.getInstance() : node), rootNode, instanceLocation, true));
        } else {
            WalkListenerRunner propertyWalkListenerRunner = this.validationContext.getConfig().getPropertyWalkListenerRunner();
            for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
                this.walkSchema(executionContext, entry, node, rootNode, instanceLocation, shouldValidateSchema, validationMessages, propertyWalkListenerRunner);
            }
        }
        return validationMessages;
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedPropertiesValidator();
    }

    private boolean hasUnevaluatedPropertiesValidator() {
        if (this.hasUnevaluatedPropertiesValidator == null) {
            this.hasUnevaluatedPropertiesValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedProperties");
        }
        return this.hasUnevaluatedPropertiesValidator;
    }

    private void applyPropertyDefaults(ObjectNode node) {
        for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
            boolean applyDefault;
            JsonNode propertyNode = node.get(entry.getKey());
            JsonNode defaultNode = PropertiesValidator.getDefaultNode(entry.getValue());
            if (defaultNode == null || !(applyDefault = propertyNode == null || propertyNode.isNull() && this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyPropertyDefaultsIfNull())) continue;
            node.set(entry.getKey(), defaultNode);
        }
    }

    private static JsonNode getDefaultNode(JsonSchema schema) {
        JsonSchemaRef schemaRef;
        JsonNode result = schema.getSchemaNode().get("default");
        if (result == null && (schemaRef = JsonSchemaRefs.from(schema)) != null) {
            result = PropertiesValidator.getDefaultNode(schemaRef.getSchema());
        }
        return result;
    }

    private void walkSchema(ExecutionContext executionContext, Map.Entry<String, JsonSchema> entry, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema, SetView<ValidationMessage> validationMessages, WalkListenerRunner propertyWalkListenerRunner) {
        JsonSchema propertySchema = entry.getValue();
        JsonNode propertyNode = node == null ? null : node.get(entry.getKey());
        JsonNodePath path = instanceLocation.append(entry.getKey());
        boolean executeWalk = propertyWalkListenerRunner.runPreWalkListeners(executionContext, ValidatorTypeCode.PROPERTIES.getValue(), propertyNode, rootNode, path, propertySchema, this);
        if (propertyNode == null && node != null) {
            propertyNode = node.get(entry.getKey());
        }
        if (executeWalk) {
            validationMessages.union(propertySchema.walk(executionContext, propertyNode, rootNode, path, shouldValidateSchema));
        }
        propertyWalkListenerRunner.runPostWalkListeners(executionContext, ValidatorTypeCode.PROPERTIES.getValue(), propertyNode, rootNode, path, propertySchema, this, validationMessages);
    }

    public Map<String, JsonSchema> getSchemas() {
        return this.schemas;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas.values());
        this.collectAnnotations();
    }
}

