/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.util;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class Utils {
    public static boolean hasText(@Nullable String str) {
        return str != null && !str.isBlank();
    }

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static URI resolveUri(URI baseUrl, String endpointUrl) {
        if (!Utils.hasText(endpointUrl)) {
            return baseUrl;
        }
        URI endpointUri = URI.create(endpointUrl);
        if (endpointUri.isAbsolute() && !Utils.isUnderBaseUri(baseUrl, endpointUri)) {
            throw new IllegalArgumentException("Absolute endpoint URL does not match the base URL.");
        }
        return baseUrl.resolve(endpointUri);
    }

    private static boolean isUnderBaseUri(URI baseUri, URI endpointUri) {
        if (!baseUri.getScheme().equals(endpointUri.getScheme()) || !baseUri.getAuthority().equals(endpointUri.getAuthority())) {
            return false;
        }
        URI normalizedBase = baseUri.normalize();
        URI normalizedEndpoint = endpointUri.normalize();
        String basePath = normalizedBase.getPath();
        String endpointPath = normalizedEndpoint.getPath();
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return endpointPath.startsWith(basePath);
    }
}

