/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import com.oracle.labs.mlrg.olcut.util.StopWatch;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

public class NanoWatch
extends StopWatch
implements Serializable {
    public static final DecimalFormat nanoPartFormat = new DecimalFormat("#,###");

    @Override
    public void start() {
        this.lastStart = System.nanoTime();
    }

    @Override
    public void stop() {
        ++this.clicks;
        this.lastTime = System.nanoTime() - this.lastStart;
        this.time += this.lastTime;
    }

    public long getTimeNanos() {
        return this.time;
    }

    public long getLastTimeNanos() {
        return this.lastTime;
    }

    public long getLastStartNanos() {
        return this.lastStart;
    }

    public double getAvgTimeNanos() {
        return (double)this.getTimeNanos() / (double)this.clicks;
    }

    @Override
    public String toString() {
        return NanoWatch.formatNanosecondTime(this.time);
    }

    public static final String formatNanosecondTime(long nanos) {
        if (nanos < TimeUnit.SECONDS.toNanos(1L)) {
            return String.format("%s nanos", nanoPartFormat.format(nanos));
        }
        if (nanos < TimeUnit.DAYS.toNanos(1L)) {
            return String.format("%02d:%02d:%02d and %s nanos", TimeUnit.NANOSECONDS.toHours(nanos), TimeUnit.NANOSECONDS.toMinutes(nanos) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.NANOSECONDS.toSeconds(nanos) % TimeUnit.MINUTES.toSeconds(1L), nanoPartFormat.format(nanos % TimeUnit.SECONDS.toNanos(1L)));
        }
        return String.format("%d days %02d:%02d:%02d and %s nanos", TimeUnit.NANOSECONDS.toDays(nanos), TimeUnit.NANOSECONDS.toHours(nanos) % TimeUnit.DAYS.toHours(1L), TimeUnit.NANOSECONDS.toMinutes(nanos) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.NANOSECONDS.toSeconds(nanos) % TimeUnit.MINUTES.toSeconds(1L), nanoPartFormat.format(nanos % TimeUnit.SECONDS.toNanos(1L)));
    }

    @Override
    public TimeUnit getUnit() {
        return TimeUnit.NANOSECONDS;
    }
}

