/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.DistanceUnit;
import org.opensearch.client.opensearch._types.GeoDistanceType;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.opensearch._types.query_dsl.GeoValidationMethod;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoDistanceQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, GeoDistanceQuery> {
    @Nonnull
    private final String distance;
    @Nullable
    private final GeoDistanceType distanceType;
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nonnull
    private final GeoLocation location;
    @Nullable
    private final DistanceUnit unit;
    @Nullable
    private final GeoValidationMethod validationMethod;
    public static final JsonpDeserializer<GeoDistanceQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceQuery::setupGeoDistanceQueryDeserializer);

    private GeoDistanceQuery(Builder builder) {
        super(builder);
        this.distance = ApiTypeHelper.requireNonNull(builder.distance, this, "distance");
        this.distanceType = builder.distanceType;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.location = ApiTypeHelper.requireNonNull(builder.location, this, "location");
        this.unit = builder.unit;
        this.validationMethod = builder.validationMethod;
    }

    public static GeoDistanceQuery of(Function<Builder, ObjectBuilder<GeoDistanceQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.GeoDistance;
    }

    @Nonnull
    public final String distance() {
        return this.distance;
    }

    @Nullable
    public final GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nonnull
    public final GeoLocation location() {
        return this.location;
    }

    @Nullable
    public final DistanceUnit unit() {
        return this.unit;
    }

    @Nullable
    public final GeoValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey(this.field);
        this.location.serialize(generator, mapper);
        generator.writeKey("distance");
        generator.write(this.distance);
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
        if (this.validationMethod != null) {
            generator.writeKey("validation_method");
            this.validationMethod.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoDistanceQueryDeserializer(ObjectDeserializer<Builder> op) {
        GeoDistanceQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::distance, JsonpDeserializer.stringDeserializer(), "distance");
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type");
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::unit, DistanceUnit._DESERIALIZER, "unit");
        op.add(Builder::validationMethod, GeoValidationMethod._DESERIALIZER, "validation_method");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.location(GeoLocation._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.distance.hashCode();
        result = 31 * result + Objects.hashCode(this.distanceType);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreUnmapped);
        result = 31 * result + this.location.hashCode();
        result = 31 * result + Objects.hashCode(this.unit);
        result = 31 * result + Objects.hashCode(this.validationMethod);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceQuery other = (GeoDistanceQuery)o;
        return this.distance.equals(other.distance) && Objects.equals(this.distanceType, other.distanceType) && this.field.equals(other.field) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped) && this.location.equals(other.location) && Objects.equals(this.unit, other.unit) && Objects.equals(this.validationMethod, other.validationMethod);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeoDistanceQuery> {
        private String distance;
        @Nullable
        private GeoDistanceType distanceType;
        private String field;
        @Nullable
        private Boolean ignoreUnmapped;
        private GeoLocation location;
        @Nullable
        private DistanceUnit unit;
        @Nullable
        private GeoValidationMethod validationMethod;

        public Builder() {
        }

        private Builder(GeoDistanceQuery o) {
            super(o);
            this.distance = o.distance;
            this.distanceType = o.distanceType;
            this.field = o.field;
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.location = o.location;
            this.unit = o.unit;
            this.validationMethod = o.validationMethod;
        }

        private Builder(Builder o) {
            super(o);
            this.distance = o.distance;
            this.distanceType = o.distanceType;
            this.field = o.field;
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.location = o.location;
            this.unit = o.unit;
            this.validationMethod = o.validationMethod;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder distance(String value) {
            this.distance = value;
            return this;
        }

        @Nonnull
        public final Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Nonnull
        public final Builder location(GeoLocation value) {
            this.location = value;
            return this;
        }

        @Nonnull
        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        @Nonnull
        public final Builder unit(@Nullable DistanceUnit value) {
            this.unit = value;
            return this;
        }

        @Nonnull
        public final Builder validationMethod(@Nullable GeoValidationMethod value) {
            this.validationMethod = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoDistanceQuery build() {
            this._checkSingleUse();
            return new GeoDistanceQuery(this);
        }
    }
}

