/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.DocumentContentBlocksCopier;
import software.amazon.awssdk.services.bedrockruntime.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentSource> {
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("bytes").getter(DocumentSource.getter(DocumentSource::bytes)).setter(DocumentSource.setter(Builder::bytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytes").build()}).build();
    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(DocumentSource.getter(DocumentSource::s3Location)).setter(DocumentSource.setter(Builder::s3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(DocumentSource.getter(DocumentSource::text)).setter(DocumentSource.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<List<DocumentContentBlock>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("content").getter(DocumentSource.getter(DocumentSource::content)).setter(DocumentSource.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTES_FIELD, S3_LOCATION_FIELD, TEXT_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes bytes;
    private final S3Location s3Location;
    private final String text;
    private final List<DocumentContentBlock> content;
    private final Type type;

    private DocumentSource(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.s3Location = builder.s3Location;
        this.text = builder.text;
        this.content = builder.content;
        this.type = builder.type;
    }

    public final SdkBytes bytes() {
        return this.bytes;
    }

    public final S3Location s3Location() {
        return this.s3Location;
    }

    public final String text() {
        return this.text;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<DocumentContentBlock> content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentSource)) {
            return false;
        }
        DocumentSource other = (DocumentSource)obj;
        return Objects.equals(this.bytes(), other.bytes()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.text(), other.text()) && this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentSource").add("Bytes", (Object)this.bytes()).add("S3Location", (Object)this.s3Location()).add("Text", (Object)this.text()).add("Content", this.hasContent() ? this.content() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public static DocumentSource fromBytes(SdkBytes bytes) {
        return (DocumentSource)DocumentSource.builder().bytes(bytes).build();
    }

    public static DocumentSource fromS3Location(S3Location s3Location) {
        return (DocumentSource)DocumentSource.builder().s3Location(s3Location).build();
    }

    public static DocumentSource fromS3Location(Consumer<S3Location.Builder> s3Location) {
        S3Location.Builder builder = S3Location.builder();
        s3Location.accept(builder);
        return DocumentSource.fromS3Location((S3Location)builder.build());
    }

    public static DocumentSource fromText(String text) {
        return (DocumentSource)DocumentSource.builder().text(text).build();
    }

    public static DocumentSource fromContent(List<DocumentContentBlock> content) {
        return (DocumentSource)DocumentSource.builder().content(content).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bytes", BYTES_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentSource, T> g) {
        return obj -> g.apply((DocumentSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BYTES,
        S3_LOCATION,
        TEXT,
        CONTENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes bytes;
        private S3Location s3Location;
        private String text;
        private List<DocumentContentBlock> content = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentSource model) {
            this.bytes(model.bytes);
            this.s3Location(model.s3Location);
            this.text(model.text);
            this.content(model.content);
        }

        public final ByteBuffer getBytes() {
            return this.bytes == null ? null : this.bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            this.bytes(bytes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            SdkBytes oldValue = this.bytes;
            this.bytes = bytes;
            this.handleUnionValueChange(Type.BYTES, oldValue, this.bytes);
            return this;
        }

        public final S3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            S3Location oldValue = this.s3Location;
            this.s3Location = s3Location != null ? s3Location.build() : null;
            this.handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            S3Location oldValue = this.s3Location;
            this.s3Location = s3Location;
            this.handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final List<DocumentContentBlock.Builder> getContent() {
            List<DocumentContentBlock.Builder> result = DocumentContentBlocksCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<DocumentContentBlock.BuilderImpl> content) {
            List<DocumentContentBlock> oldValue = this.content;
            this.content = DocumentContentBlocksCopier.copyFromBuilder(content);
            this.handleUnionValueChange(Type.CONTENT, oldValue, this.content);
        }

        @Override
        public final Builder content(Collection<DocumentContentBlock> content) {
            List<DocumentContentBlock> oldValue = this.content;
            this.content = DocumentContentBlocksCopier.copy(content);
            this.handleUnionValueChange(Type.CONTENT, oldValue, this.content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(DocumentContentBlock ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<DocumentContentBlock.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (DocumentContentBlock)((DocumentContentBlock.Builder)DocumentContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DocumentSource build() {
            return new DocumentSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentSource> {
        public Builder bytes(SdkBytes var1);

        public Builder s3Location(S3Location var1);

        default public Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return this.s3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3Location)).build());
        }

        public Builder text(String var1);

        public Builder content(Collection<DocumentContentBlock> var1);

        public Builder content(DocumentContentBlock ... var1);

        public Builder content(Consumer<DocumentContentBlock.Builder> ... var1);
    }
}

