/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.TotalHits;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

public class HitsMetadata<TDocument>
implements PlainJsonSerializable,
ToCopyableBuilder<Builder<TDocument>, HitsMetadata<TDocument>> {
    @Nonnull
    private final List<Hit<TDocument>> hits;
    @Nullable
    private final Float maxScore;
    @Nullable
    private final TotalHits total;

    private HitsMetadata(Builder<TDocument> builder) {
        this.hits = ApiTypeHelper.unmodifiableRequired(((Builder)builder).hits, (Object)this, "hits");
        this.maxScore = ((Builder)builder).maxScore;
        this.total = ((Builder)builder).total;
    }

    public static <TDocument> HitsMetadata<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<Hit<TDocument>> hits() {
        return this.hits;
    }

    @Nullable
    public final Float maxScore() {
        return this.maxScore;
    }

    @Nullable
    public final TotalHits total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("hits");
        generator.writeStartArray();
        for (Hit<TDocument> item0 : this.hits) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write((double)this.maxScore.floatValue());
        }
        if (this.total != null) {
            generator.writeKey("total");
            this.total.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder<TDocument> toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static <TDocument> Builder builder() {
        return new Builder();
    }

    public static <TDocument> JsonpDeserializer<HitsMetadata<TDocument>> createHitsMetadataDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> HitsMetadata.setupHitsMetadataDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupHitsMetadataDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::hits, JsonpDeserializer.arrayDeserializer(Hit.createHitDeserializer(tDocumentDeserializer)), "hits");
        op.add(Builder::maxScore, JsonpDeserializer.floatDeserializer(), "max_score");
        op.add(Builder::total, TotalHits._DESERIALIZER, "total");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.hits.hashCode();
        result = 31 * result + Objects.hashCode(this.maxScore);
        result = 31 * result + Objects.hashCode(this.total);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HitsMetadata other = (HitsMetadata)o;
        return this.hits.equals(other.hits) && Objects.equals(this.maxScore, other.maxScore) && Objects.equals(this.total, other.total);
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder<TDocument>, HitsMetadata<TDocument>> {
        private List<Hit<TDocument>> hits;
        @Nullable
        private Float maxScore;
        @Nullable
        private TotalHits total;

        public Builder() {
        }

        private Builder(HitsMetadata<TDocument> o) {
            this.hits = Builder._listCopy(((HitsMetadata)o).hits);
            this.maxScore = ((HitsMetadata)o).maxScore;
            this.total = ((HitsMetadata)o).total;
        }

        private Builder(Builder<TDocument> o) {
            this.hits = Builder._listCopy(o.hits);
            this.maxScore = o.maxScore;
            this.total = o.total;
        }

        @Override
        @Nonnull
        public Builder<TDocument> copy() {
            return new Builder<TDocument>(this);
        }

        @Nonnull
        public final Builder<TDocument> hits(List<Hit<TDocument>> list) {
            this.hits = Builder._listAddAll(this.hits, list);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> hits(Hit<TDocument> value, Hit<TDocument> ... values) {
            this.hits = Builder._listAdd(this.hits, value, values);
            return this;
        }

        @Nonnull
        public final Builder<TDocument> hits(Function<Hit.Builder<TDocument>, ObjectBuilder<Hit<TDocument>>> fn) {
            return this.hits(fn.apply(new Hit.Builder()).build(), new Hit[0]);
        }

        @Nonnull
        public final Builder<TDocument> maxScore(@Nullable Float value) {
            this.maxScore = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> total(@Nullable TotalHits value) {
            this.total = value;
            return this;
        }

        @Nonnull
        public final Builder<TDocument> total(Function<TotalHits.Builder, ObjectBuilder<TotalHits>> fn) {
            return this.total(fn.apply(new TotalHits.Builder()).build());
        }

        @Override
        @Nonnull
        public HitsMetadata<TDocument> build() {
            this._checkSingleUse();
            return new HitsMetadata(this);
        }
    }
}

