/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.security.auth.UserSubjectImpl;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.resources.ResourceSharingIndexHandler;
import org.opensearch.security.resources.sharing.CreatedBy;
import org.opensearch.security.resources.sharing.ResourceSharing;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.security.spi.resources.ResourceProvider;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class ResourceIndexListener
implements IndexingOperationListener {
    private static final Logger log = LogManager.getLogger(ResourceIndexListener.class);
    private final ResourceSharingIndexHandler resourceSharingIndexHandler;
    private final ThreadPool threadPool;
    private final ResourcePluginInfo resourcePluginInfo;
    private final OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting;

    public ResourceIndexListener(ThreadPool threadPool, Client client, ResourcePluginInfo resourcePluginInfo, OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting) {
        this.threadPool = threadPool;
        this.resourceSharingIndexHandler = new ResourceSharingIndexHandler(client, threadPool, resourcePluginInfo);
        this.resourcePluginInfo = resourcePluginInfo;
        this.resourceSharingEnabledSetting = resourceSharingEnabledSetting;
    }

    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        if (!this.resourceSharingEnabledSetting.getDynamicSettingValue().booleanValue()) {
            return;
        }
        String resourceIndex = shardId.getIndexName();
        if (!this.resourcePluginInfo.getResourceIndicesForProtectedTypes().contains(resourceIndex)) {
            return;
        }
        log.debug("postIndex called on {}", (Object)resourceIndex);
        String resourceType = this.resourcePluginInfo.getResourceTypeForIndexOp(resourceIndex, index);
        String resourceId = index.id();
        ResourceProvider provider = this.resourcePluginInfo.getResourceProvider(resourceType);
        if (provider == null) {
            log.warn("Failed to create a resource sharing entry for resource: {} with type: {}. The type is not declared as a protected type in plugins.security.experimental.resource_sharing.protected_types.", (Object)resourceId, (Object)resourceType);
            return;
        }
        if (!index.origin().equals((Object)Engine.Operation.Origin.PRIMARY)) {
            log.debug("Skipping resource sharing entry creation for {} as this operation was on a replica shard", (Object)resourceId);
            return;
        }
        if (!result.isCreated()) {
            ActionListener listener = ActionListener.wrap(unused -> log.debug("postIndex: Successfully updated the resource visibility for resource {} within index {}", (Object)resourceId, (Object)resourceIndex), e -> log.debug(e.getMessage()));
            this.resourceSharingIndexHandler.fetchAndUpdateResourceVisibility(resourceId, resourceIndex, (ActionListener<Void>)listener);
            return;
        }
        UserSubjectImpl userSubject = (UserSubjectImpl)this.threadPool.getThreadContext().getPersistent("_opendistro_security_authenticated_user");
        User user = userSubject.getUser();
        try {
            Objects.requireNonNull(user);
            ActionListener listener = ActionListener.wrap(entry -> log.debug("postIndex: Successfully created a resource sharing entry {} for resource {} within index {}", entry, (Object)resourceId, (Object)resourceIndex), e -> log.debug(e.getMessage()));
            ResourceSharing.Builder builder = ResourceSharing.builder().resourceId(resourceId).resourceType(resourceType).createdBy(new CreatedBy(user.getName(), user.getRequestedTenant()));
            ResourceSharing sharingInfo = builder.build();
            this.resourceSharingIndexHandler.indexResourceSharing(resourceIndex, sharingInfo, (ActionListener<ResourceSharing>)listener);
        }
        catch (IOException e2) {
            log.debug("Failed to create a resource sharing entry for resource: {}", (Object)resourceId, (Object)e2);
        }
    }

    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        if (!this.resourceSharingEnabledSetting.getDynamicSettingValue().booleanValue()) {
            return;
        }
        String resourceIndex = shardId.getIndexName();
        if (!this.resourcePluginInfo.getResourceIndicesForProtectedTypes().contains(resourceIndex)) {
            return;
        }
        log.debug("postDelete called on {}", (Object)resourceIndex);
        String resourceId = delete.id();
        this.resourceSharingIndexHandler.deleteResourceSharingRecord(resourceId, resourceIndex, (ActionListener<Boolean>)ActionListener.wrap(deleted -> {
            if (deleted.booleanValue()) {
                log.debug("Successfully deleted resource sharing entry for resource {}", (Object)resourceId);
            } else {
                log.debug("No resource sharing entry found for resource {}", (Object)resourceId);
            }
        }, exception -> log.error("Failed to delete resource sharing entry for resource {}", (Object)resourceId, exception)));
    }
}

