/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import net.sourceforge.plantuml.real.AbstractReal;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealMoveable;

class RealDelta
extends RealMoveable {
    private final Real delegated;
    private final double diff;

    RealDelta(Real delegated, double diff) {
        super(((AbstractReal)delegated).getLine(), "[Delegated {" + delegated.getName() + "} d=" + diff + "]");
        this.delegated = delegated;
        this.diff = diff;
    }

    @Override
    double getCurrentValueInternal() {
        return this.delegated.getCurrentValue() + this.diff;
    }

    @Override
    public Real addAtLeast(double delta) {
        return new RealDelta(this.delegated.addAtLeast(delta), this.diff);
    }

    @Override
    public void ensureBiggerThan(Real other) {
        this.delegated.ensureBiggerThan(new RealDelta(other, -this.diff));
    }

    @Override
    void move(double delta) {
        ((RealMoveable)this.delegated).move(delta);
    }
}

