/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.time.YearMonth;
import java.util.Map;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeekUtils;
import net.sourceforge.plantuml.project.time.YearMonthUtils;
import net.sourceforge.plantuml.project.timescale.TimeScaleDaily;
import net.sourceforge.plantuml.project.timescale.TimeScaleDailyHideClosed;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;

public class TimeHeaderDaily
extends TimeHeaderCalendar {
    private final Map<Day, String> nameDays;

    private double getH1(StringBounder stringBounder) {
        double h = this.thParam.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble() + 2.0;
        return h;
    }

    private double getH2(StringBounder stringBounder) {
        double h = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble() + 2.0;
        return this.getH1(stringBounder) + h;
    }

    private double getH3(StringBounder stringBounder) {
        double h = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble() + 3.0;
        return this.getH2(stringBounder) + h;
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        return this.getH3(stringBounder);
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h1 = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        double h2 = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        double h3 = this.thParam.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble();
        return h1 + h2 + h3 + 8.0;
    }

    private double getHeaderNameDayHeight() {
        if (this.nameDays.size() > 0) {
            double h = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble() + 6.0;
            return h;
        }
        return 0.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    public TimeHeaderDaily(StringBounder stringBounder, TimeHeaderParameters thParam, Map<Day, String> nameDays, Day printStart) {
        super(thParam, thParam.isHideClosed() ? new TimeScaleDailyHideClosed(thParam.getCellWidth(stringBounder), thParam.getStartingDay(), thParam.getScale(), thParam.getOpenClose()) : new TimeScaleDaily(thParam.getCellWidth(stringBounder), thParam.getStartingDay(), thParam.getScale(), printStart));
        this.nameDays = nameDays;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawTextsDayOfWeek(ug.apply(UTranslate.dy(this.getH1(ug.getStringBounder()))));
        this.drawTextDayOfMonth(ug.apply(UTranslate.dy(this.getH2(ug.getStringBounder()))));
        this.drawMonths(ug);
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.printNamedDays(ug);
        this.drawHline(ug, this.getFullHeaderHeight(ug.getStringBounder()));
        this.drawHline(ug, totalHeightWithoutFooter);
    }

    @Override
    protected void printVerticalSeparators(UGraphic ug, double totalHeightWithoutFooter) {
        UGraphic ugVerticalSeparator = this.thParam.forVerticalSeparator(ug);
        UGraphic ugLineColor = ug.apply(this.getLineColor());
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) <= 0) {
            if (this.isBold2(wink) || this.getTimeScale().getWidth(wink.decrement()) == 0.0) {
                this.drawVline(ugVerticalSeparator, this.getTimeScale().getStartingPosition(wink), this.getFullHeaderHeight(ug.getStringBounder()), totalHeightWithoutFooter);
            } else {
                this.drawVline(ugLineColor, this.getTimeScale().getStartingPosition(wink), this.getFullHeaderHeight(ug.getStringBounder()), totalHeightWithoutFooter);
            }
            wink = wink.increment();
        }
        this.drawVline(ugLineColor, this.getTimeScale().getEndingPosition(this.getMax()), this.getFullHeaderHeight(ug.getStringBounder()), totalHeightWithoutFooter);
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        double h = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble() + 2.0;
        this.drawTextsDayOfWeek(ug);
        this.drawTextDayOfMonth(ug.apply(UTranslate.dy(h + 2.0)));
        this.drawMonths(ug.apply(UTranslate.dy(2.0 * h + 3.0)));
    }

    private void drawTextsDayOfWeek(UGraphic ug) {
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) <= 0) {
            if (!this.isHidden(wink)) {
                double x1 = this.getTimeScale().getStartingPosition(wink);
                double x2 = this.getTimeScale().getEndingPosition(wink);
                HColor textColor = this.getTextBackColor(wink);
                this.printCentered(ug, this.getTextBlock(SName.day, DayOfWeekUtils.shortName(wink.getDayOfWeek(), this.locale()), false, textColor), x1, x2);
            }
            wink = wink.increment();
        }
    }

    private void drawTextDayOfMonth(UGraphic ug) {
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) <= 0) {
            if (!this.isHidden(wink)) {
                double x1 = this.getTimeScale().getStartingPosition(wink);
                double x2 = this.getTimeScale().getEndingPosition(wink);
                HColor textColor = this.getTextBackColor(wink);
                this.printCentered(ug, this.getTextBlock(SName.day, "" + wink.getDayOfMonth(), false, textColor), x1, x2);
            }
            wink = wink.increment();
        }
    }

    private boolean isHidden(Day wink) {
        return this.thParam.isHideClosed() && this.thParam.getOpenClose().isClosed(wink);
    }

    private HColor getTextBackColor(Day wink) {
        if (this.getLoadAt(wink) <= 0) {
            return this.closedFontColor();
        }
        return this.openFontColor();
    }

    private void drawMonths(UGraphic ug) {
        YearMonth last = null;
        double lastChangeMonth = -1.0;
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) <= 0) {
            if (!this.isHidden(wink)) {
                double x1 = this.getTimeScale().getStartingPosition(wink);
                if (!wink.monthYear().equals(last)) {
                    if (last != null) {
                        this.printMonth(ug, last, lastChangeMonth, x1);
                    }
                    lastChangeMonth = x1;
                    last = wink.monthYear();
                }
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.getMax().increment());
        if (x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void printMonth(UGraphic ug, YearMonth monthYear, double start, double end) {
        TextBlock tiny = this.getTextBlock(SName.month, YearMonthUtils.shortName(monthYear, this.locale()), true, this.openFontColor());
        TextBlock small = this.getTextBlock(SName.month, YearMonthUtils.longName(monthYear, this.locale()), true, this.openFontColor());
        TextBlock big = this.getTextBlock(SName.month, YearMonthUtils.longNameYYYY(monthYear, this.locale()), true, this.openFontColor());
        this.printCentered(ug, false, start, end, tiny, small, big);
    }

    private void printNamedDays(UGraphic ug) {
        if (this.nameDays.size() > 0) {
            String last = null;
            Day wink = this.getMin();
            while (wink.compareTo(this.getMax().increment()) <= 0) {
                String name = this.nameDays.get(wink);
                if (name != null && !name.equals(last)) {
                    double x1 = this.getTimeScale().getStartingPosition(wink);
                    double x2 = this.getTimeScale().getEndingPosition(wink);
                    TextBlock label = this.getTextBlock(SName.month, name, false, this.openFontColor());
                    double h = label.calculateDimension(ug.getStringBounder()).getHeight();
                    double y1 = this.getTimeHeaderHeight(ug.getStringBounder());
                    double y2 = this.getFullHeaderHeight(ug.getStringBounder());
                    double position = this.getH3(ug.getStringBounder());
                    label.drawU(ug.apply(new UTranslate(x1, position)));
                }
                last = name;
                wink = wink.increment();
            }
        }
    }
}

