/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.validation.PyAnnotationHolder;
import org.jetbrains.annotations.NotNull;

public class PyTypeAnnotationTargetAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    public PyTypeAnnotationTargetAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyTypeAnnotationTargetAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
        if (node == null) {
            PyTypeAnnotationTargetAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if (node.getAnnotation() != null && LanguageLevel.forElement((PsiElement)node).isAtLeast(LanguageLevel.PYTHON36)) {
            PyExpression target;
            if (node.getRawTargets().length > 1) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.variable.annotation.cannot.be.used.in.assignment.with.multiple.targets", new Object[0])).create();
            }
            if ((target = node.getLeftHandSideExpression()) != null) {
                this.checkAnnotationTarget(target);
            }
        }
    }

    public void visitPyTypeDeclarationStatement(@NotNull PyTypeDeclarationStatement node) {
        if (node == null) {
            PyTypeAnnotationTargetAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if (node.getAnnotation() != null && LanguageLevel.forElement((PsiElement)node).isAtLeast(LanguageLevel.PYTHON36)) {
            this.checkAnnotationTarget(node.getTarget());
        }
    }

    private void checkAnnotationTarget(@NotNull PyExpression expression) {
        PyExpression innerExpr;
        if (expression == null) {
            PyTypeAnnotationTargetAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        if ((innerExpr = PyPsiUtils.flattenParens((PyExpression)expression)) instanceof PyTupleExpression || innerExpr instanceof PyListLiteralExpression) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.variable.annotation.cannot.be.combined.with.tuple.unpacking", new Object[0])).range((PsiElement)innerExpr).create();
        } else if (innerExpr != null && !(innerExpr instanceof PyTargetExpression) && !(innerExpr instanceof PySubscriptionExpression)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.illegal.target.for.variable.annotation", new Object[0])).range((PsiElement)innerExpr).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyTypeAnnotationTargetAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyAssignmentStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyTypeDeclarationStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotationTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

