/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.rule;

import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import ai.grazie.text.exclusions.Exclusion;
import ai.grazie.text.exclusions.ExclusionUtilsKt;
import ai.grazie.text.exclusions.SentenceWithExclusions;
import com.intellij.grazie.text.TextContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ranges.IntRange;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentenceTokenizer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.grazie.text.SentenceTokenizer");
    private static final Key<List<Sentence>> tokenized = Key.create((String)"grazie pro sentence tokenization");
    private static final Method unknownOffsets = ReflectionUtil.getMethod(TextContent.class, (String)"unknownOffsets", (Class[])new Class[0]);

    public static List<Tokenizer.Token> tokenize(@NotNull CharSequence text) {
        if (text == null) {
            SentenceTokenizer.$$$reportNull$$$0(0);
        }
        CharSequence bombed = SentenceTokenizer.bombed(text);
        return ContainerUtil.map((Collection)StandardSentenceTokenizer.Companion.getDefault().tokenRanges(bombed), r -> new Tokenizer.Token(text.subSequence(r.getStart(), r.getEndExclusive()).toString(), new IntRange(r.getStart(), r.getEndInclusive())));
    }

    private static CharSequence bombed(@NotNull CharSequence text) {
        if (text == null) {
            SentenceTokenizer.$$$reportNull$$$0(1);
        }
        if (ProgressManager.getGlobalProgressIndicator() == null && Cancellation.currentJob() == null && !ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("Sentence tokenizer should be called with a cancellable indicator");
        }
        return new StringUtil.BombedCharSequence(text){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
    }

    public static List<Sentence> tokenize(@NotNull TextContent content) {
        List result;
        if (content == null) {
            SentenceTokenizer.$$$reportNull$$$0(2);
        }
        if ((result = (List)content.getUserData(tokenized)) == null) {
            List<Exclusion> exclusions2 = SentenceTokenizer.rangeExclusions(content, com.intellij.openapi.util.TextRange.from((int)0, (int)content.length()));
            Text text = ExclusionUtilsKt.withExclusions((Text)new Text(SentenceTokenizer.bombed(content)), exclusions2);
            result = ContainerUtil.map((Collection)StandardSentenceTokenizer.Companion.getDefault().tokenize(text), SentenceTokenizer::toSentence);
            content.putUserData(tokenized, result);
        }
        return result;
    }

    private static Sentence toSentence(Tokenizer.Token token) {
        TextRange range = new TextRange(token.getRange().getFirst(), token.getRange().getLast() + 1);
        List exclusions2 = ExclusionUtilsKt.getExclusions((Text)token.getText());
        return new Sentence(range.getStart(), token.getToken(), exclusions2);
    }

    public static List<Exclusion> rangeExclusions(TextContent textContent, com.intellij.openapi.util.TextRange range) {
        return ((StreamEx)StreamEx.of(SentenceTokenizer.exclusionsInRange(range, textContent.markupOffsets(), Exclusion.Kind.Markup)).append(SentenceTokenizer.unknownOffsets(textContent, range)).sortedBy(Exclusion::getOffset)).toList();
    }

    private static List<Exclusion> exclusionsInRange(com.intellij.openapi.util.TextRange range, int[] offsets, Exclusion.Kind kind) {
        return IntStreamEx.of((int[])offsets).filter(arg_0 -> ((com.intellij.openapi.util.TextRange)range).contains(arg_0)).mapToObj(offset -> new Exclusion(offset - range.getStartOffset(), kind)).toList();
    }

    private static List<Exclusion> unknownOffsets(final TextContent textContent, final com.intellij.openapi.util.TextRange range) {
        if (unknownOffsets != null) {
            try {
                return SentenceTokenizer.exclusionsInRange(range, (int[])unknownOffsets.invoke((Object)textContent, new Object[0]), Exclusion.Kind.Unknown);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        final ArrayList<Exclusion> exclusions2 = new ArrayList<Exclusion>();
        new Object(){

            private void findUnknownOffsets(int start, int end) {
                if (textContent.hasUnknownFragmentsIn(new com.intellij.openapi.util.TextRange(start, end))) {
                    if (start == end) {
                        exclusions2.add(new Exclusion(start - range.getStartOffset(), Exclusion.Kind.Unknown));
                    } else {
                        int middle = (start + end) / 2;
                        this.findUnknownOffsets(start, middle);
                        this.findUnknownOffsets(middle + 1, end);
                    }
                }
            }
        }.findUnknownOffsets(range.getStartOffset(), range.getEndOffset());
        return exclusions2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/grazie/rule/SentenceTokenizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tokenize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "bombed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record Sentence(int start, String text, List<Exclusion> exclusions) {
        public int end() {
            return this.start + this.text.length();
        }

        public SentenceWithExclusions swe() {
            return new SentenceWithExclusions(this.text, this.exclusions);
        }

        @Nullable
        public SentenceWithExclusions stubbedSwe() {
            String text = this.swe().stubExclusions();
            return text == null ? null : new SentenceWithExclusions(text, List.of());
        }
    }
}

