/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.Converter;

public abstract class StdConverter<IN, OUT>
implements Converter<IN, OUT> {
    @Override
    public OUT convert(DeserializationContext ctxt, IN value) {
        return this.convert(value);
    }

    @Override
    public OUT convert(SerializationContext ctxt, IN value) {
        return this.convert(value);
    }

    public abstract OUT convert(IN var1);

    @Override
    public JavaType getInputType(TypeFactory typeFactory) {
        return this._findConverterType(typeFactory).containedType(0);
    }

    @Override
    public JavaType getOutputType(TypeFactory typeFactory) {
        return this._findConverterType(typeFactory).containedType(1);
    }

    protected JavaType _findConverterType(TypeFactory tf) {
        JavaType thisType = tf.constructType(this.getClass());
        JavaType convType = thisType.findSuperType(Converter.class);
        if (convType == null || convType.containedTypeCount() < 2) {
            throw new IllegalStateException("Cannot find OUT type parameter for Converter of type " + this.getClass().getName());
        }
        return convType;
    }
}

