﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigServiceRequest.h>
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/RemediationExceptionResourceKey.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace ConfigService {
namespace Model {

/**
 */
class DeleteRemediationExceptionsRequest : public ConfigServiceRequest {
 public:
  AWS_CONFIGSERVICE_API DeleteRemediationExceptionsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteRemediationExceptions"; }

  AWS_CONFIGSERVICE_API Aws::String SerializePayload() const override;

  AWS_CONFIGSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the Config rule for which you want to delete remediation
   * exception configuration.</p>
   */
  inline const Aws::String& GetConfigRuleName() const { return m_configRuleName; }
  inline bool ConfigRuleNameHasBeenSet() const { return m_configRuleNameHasBeenSet; }
  template <typename ConfigRuleNameT = Aws::String>
  void SetConfigRuleName(ConfigRuleNameT&& value) {
    m_configRuleNameHasBeenSet = true;
    m_configRuleName = std::forward<ConfigRuleNameT>(value);
  }
  template <typename ConfigRuleNameT = Aws::String>
  DeleteRemediationExceptionsRequest& WithConfigRuleName(ConfigRuleNameT&& value) {
    SetConfigRuleName(std::forward<ConfigRuleNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An exception list of resource exception keys to be processed with the current
   * request. Config adds exception for each resource key. For example, Config adds 3
   * exceptions for 3 resource keys. </p>
   */
  inline const Aws::Vector<RemediationExceptionResourceKey>& GetResourceKeys() const { return m_resourceKeys; }
  inline bool ResourceKeysHasBeenSet() const { return m_resourceKeysHasBeenSet; }
  template <typename ResourceKeysT = Aws::Vector<RemediationExceptionResourceKey>>
  void SetResourceKeys(ResourceKeysT&& value) {
    m_resourceKeysHasBeenSet = true;
    m_resourceKeys = std::forward<ResourceKeysT>(value);
  }
  template <typename ResourceKeysT = Aws::Vector<RemediationExceptionResourceKey>>
  DeleteRemediationExceptionsRequest& WithResourceKeys(ResourceKeysT&& value) {
    SetResourceKeys(std::forward<ResourceKeysT>(value));
    return *this;
  }
  template <typename ResourceKeysT = RemediationExceptionResourceKey>
  DeleteRemediationExceptionsRequest& AddResourceKeys(ResourceKeysT&& value) {
    m_resourceKeysHasBeenSet = true;
    m_resourceKeys.emplace_back(std::forward<ResourceKeysT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_configRuleName;
  bool m_configRuleNameHasBeenSet = false;

  Aws::Vector<RemediationExceptionResourceKey> m_resourceKeys;
  bool m_resourceKeysHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
