﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/finspace/Finspace_EXPORTS.h>
#include <aws/finspace/model/VolumeType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace finspace {
namespace Model {

/**
 * <p> The structure that consists of name and type of volume.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/finspace-2021-03-12/Volume">AWS API
 * Reference</a></p>
 */
class Volume {
 public:
  AWS_FINSPACE_API Volume() = default;
  AWS_FINSPACE_API Volume(Aws::Utils::Json::JsonView jsonValue);
  AWS_FINSPACE_API Volume& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FINSPACE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A unique identifier for the volume.</p>
   */
  inline const Aws::String& GetVolumeName() const { return m_volumeName; }
  inline bool VolumeNameHasBeenSet() const { return m_volumeNameHasBeenSet; }
  template <typename VolumeNameT = Aws::String>
  void SetVolumeName(VolumeNameT&& value) {
    m_volumeNameHasBeenSet = true;
    m_volumeName = std::forward<VolumeNameT>(value);
  }
  template <typename VolumeNameT = Aws::String>
  Volume& WithVolumeName(VolumeNameT&& value) {
    SetVolumeName(std::forward<VolumeNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The type of file system volume. Currently, FinSpace only supports
   * <code>NAS_1</code> volume type. </p>
   */
  inline VolumeType GetVolumeType() const { return m_volumeType; }
  inline bool VolumeTypeHasBeenSet() const { return m_volumeTypeHasBeenSet; }
  inline void SetVolumeType(VolumeType value) {
    m_volumeTypeHasBeenSet = true;
    m_volumeType = value;
  }
  inline Volume& WithVolumeType(VolumeType value) {
    SetVolumeType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_volumeName;
  bool m_volumeNameHasBeenSet = false;

  VolumeType m_volumeType{VolumeType::NOT_SET};
  bool m_volumeTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace finspace
}  // namespace Aws
