﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/internetmonitor/InternetMonitor_EXPORTS.h>
#include <aws/internetmonitor/model/QueryField.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace InternetMonitor {
namespace Model {
class GetQueryResultsResult {
 public:
  AWS_INTERNETMONITOR_API GetQueryResultsResult() = default;
  AWS_INTERNETMONITOR_API GetQueryResultsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_INTERNETMONITOR_API GetQueryResultsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The fields that the query returns data for. Fields are name-data type pairs,
   * such as <code>availability_score</code>-<code>float</code>.</p>
   */
  inline const Aws::Vector<QueryField>& GetFields() const { return m_fields; }
  template <typename FieldsT = Aws::Vector<QueryField>>
  void SetFields(FieldsT&& value) {
    m_fieldsHasBeenSet = true;
    m_fields = std::forward<FieldsT>(value);
  }
  template <typename FieldsT = Aws::Vector<QueryField>>
  GetQueryResultsResult& WithFields(FieldsT&& value) {
    SetFields(std::forward<FieldsT>(value));
    return *this;
  }
  template <typename FieldsT = QueryField>
  GetQueryResultsResult& AddFields(FieldsT&& value) {
    m_fieldsHasBeenSet = true;
    m_fields.emplace_back(std::forward<FieldsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data results that the query returns. Data is returned in arrays, aligned
   * with the <code>Fields</code> for the query, which creates a repository of Amazon
   * CloudWatch Internet Monitor information for your application. Then, you can
   * filter the information in the repository by using <code>FilterParameters</code>
   * that you define.</p>
   */
  inline const Aws::Vector<Aws::Vector<Aws::String>>& GetData() const { return m_data; }
  template <typename DataT = Aws::Vector<Aws::Vector<Aws::String>>>
  void SetData(DataT&& value) {
    m_dataHasBeenSet = true;
    m_data = std::forward<DataT>(value);
  }
  template <typename DataT = Aws::Vector<Aws::Vector<Aws::String>>>
  GetQueryResultsResult& WithData(DataT&& value) {
    SetData(std::forward<DataT>(value));
    return *this;
  }
  template <typename DataT = Aws::Vector<Aws::String>>
  GetQueryResultsResult& AddData(DataT&& value) {
    m_dataHasBeenSet = true;
    m_data.emplace_back(std::forward<DataT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the next set of results. You receive this token from a previous
   * call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetQueryResultsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetQueryResultsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<QueryField> m_fields;
  bool m_fieldsHasBeenSet = false;

  Aws::Vector<Aws::Vector<Aws::String>> m_data;
  bool m_dataHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace InternetMonitor
}  // namespace Aws
