﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/notifications/Notifications_EXPORTS.h>
#include <aws/notifications/model/EventRuleStructure.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Notifications {
namespace Model {
class ListEventRulesResult {
 public:
  AWS_NOTIFICATIONS_API ListEventRulesResult() = default;
  AWS_NOTIFICATIONS_API ListEventRulesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_NOTIFICATIONS_API ListEventRulesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A pagination token. If a non-null pagination token is returned in a result,
   * pass its value in another request to retrieve more entries.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListEventRulesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <code>EventRules</code>.</p>
   */
  inline const Aws::Vector<EventRuleStructure>& GetEventRules() const { return m_eventRules; }
  template <typename EventRulesT = Aws::Vector<EventRuleStructure>>
  void SetEventRules(EventRulesT&& value) {
    m_eventRulesHasBeenSet = true;
    m_eventRules = std::forward<EventRulesT>(value);
  }
  template <typename EventRulesT = Aws::Vector<EventRuleStructure>>
  ListEventRulesResult& WithEventRules(EventRulesT&& value) {
    SetEventRules(std::forward<EventRulesT>(value));
    return *this;
  }
  template <typename EventRulesT = EventRuleStructure>
  ListEventRulesResult& AddEventRules(EventRulesT&& value) {
    m_eventRulesHasBeenSet = true;
    m_eventRules.emplace_back(std::forward<EventRulesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListEventRulesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<EventRuleStructure> m_eventRules;
  bool m_eventRulesHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Notifications
}  // namespace Aws
